<?php

/**
 *--------------------------------------
 * article category
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleCategoryModl extends Modl {
	public function get_allCategory($where = array()) {
		$where[] = array('lang' => array('EQ', LANG_NAME));
		$_sign = get_guidString($where);
		$_ACL = F('_acl/_all_'.LANG_NAME.'_'.$_sign);
		if(empty($_ACL)) {
			$_ACL = $this->field('`article_category_id`,`ac_name`,`ac_alias`,`ac_thumb`,`ac_keywords`,`ac_description`,`ac_content`,`ac_parent_id`,`ac_display_switch`,`ac_display_order`,`ac_article_count`,`ac_review_count`')
				->where($where)
				->order('`ac_display_order` ASC')->select();
			if(!empty($_ACL)) {
				foreach($_ACL as $k => $v) {
					$_ACL[$k]['ac_url'] = ($v['ac_display_switch'] ? Url::U('home@article/show_category?article_category_id='.$v['article_category_id']) : '');
				}
				F('_acl/_all_'.LANG_NAME.'_'.$_sign, $_ACL);
			}
		}
		return $_ACL;
	}

	public function get_categoryList($alias = '', $displayFilter = false, $where = array()) {
		$_ACL = $this->get_allCategory($where);
		if(!empty($_ACL)) {
			foreach($_ACL as $key => $value) {
				/* filter alias */
				if(!empty($alias) and $alias != $value['ac_alias']) {
					unset($_ACL[$key]);
				}
				/* filter display */
				if($displayFilter and !$value['ac_display_switch']) {
					unset($_ACL[$key]);
				}
			}
			return $_ACL;
		}
		return null;
	}

	public function get_categoryInfo($articleCategoryId) {
		$_ACI = F('_aci/_ac_'.LANG_NAME.'_'.$articleCategoryId);
		if(empty($_ACI)) {
			$where = array();
			$where['__ARTICLE_CATEGORY__.article_category_id'] = array('EQ', $articleCategoryId);
			$where['lang'] = array('EQ', LANG_NAME);

			$_ACI = $this->where($where)->find();
			if(!empty($_ACI)) {
				/* addon field */
				$_ACI['ac_addon_field'] = unserialize($_ACI['ac_addon_field']);
				if(MAGIC_QUOTES_GPC) {
					$_ACI['ac_addon_field'] = stripslashes_array($_ACI['ac_addon_field']);
				}

				/* get sibling category */
				$_ACI['ac_child'] = $this->where(array('ac_parent_id' => array('EQ', $_ACI['article_category_id']), 'ac_display_switch' => array('EQ', 1)))->count();

				/* get position */
				$_ACL = $this->get_allCategory();
				$act = new ATree($_ACL, array('article_category_id', 'ac_parent_id', 'ac_sub_category'));
				$_ACI['ac_tree'] = $act->get_leaf(0);
				$_ACI['ac_sub_id'] = $act->get_leafid($articleCategoryId);

				$navi = $act->get_navi($articleCategoryId);
				$_ACI['ac_position'] = array();
				$_ACI['ac_position'][] = array('name' => L('HOME'), 'url' => Url::U('home@index/index'));
				foreach($navi as $k => $v) {
					$_ACI['ac_position'][] = array('name' => $v['ac_name'], 'url' => $v['ac_url']);
				}
				$_ACI['ac_url'] = ($v['ac_display_switch'] ? Url::U('home@article/show_category?article_category_id='.$_ACI['article_category_id']) : '');
			}
			F('_aci/_ac_'.LANG_NAME.'_'.$articleCategoryId, $_ACI);
		}
		return $_ACI;
	}

	public function add_category($data) {
		$result = array('data' => '', 'error' => '');

		$data['ac_alias'] = strtolower($data['ac_alias']);

		$data['ac_addon_field'] = serialize(array_values($data['ac_addon_field']));
		if(MAGIC_QUOTES_GPC) {
			$data['ac_addon_field'] = addslashes($data['ac_addon_field']);
		}

		$data['lang'] = LANG_NAME;
		unset($data['article_category_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $data['ac_alias'];

		clear_dir(DATA_PATH.D_S.'_acl');

		return $result;
	}

	public function edit_category($data) {
		$result = array('data' => '', 'error' => '');

		if(isset($data['ac_alias'])) {
			$data['ac_alias'] = strtolower($data['ac_alias']);
		}

		if(isset($data['ac_addon_field'])) {
			$data['ac_addon_field'] = serialize(array_values($data['ac_addon_field']));
			if(MAGIC_QUOTES_GPC) {
				$data['ac_addon_field'] = addslashes($data['ac_addon_field']);
			}
		}

		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		clear_dir(DATA_PATH.D_S.'_acl');
		clear_dir(DATA_PATH.D_S.'_aci');

		return $result;
	}

	public function delete_category($articleCategoryId) {
		$result = array('data' => '', 'error' => '');

		$_t_sub = $this->where(array('ac_parent_id' => array('EQ', $articleCategoryId)))->select();
		if(!empty($_t_sub)) {
			$result['error'] = L('SUB_CATEGORY_EXIST');
			return $result;
		}

		$_ACI = M('ArticleCategory')->get_categoryInfo($articleCategoryId);
		/* delete article */
		$_AL = M('Article')->field('article_id')->where(array('article_category_id' => array('EQ', $articleCategoryId)))->select();
		if(!empty($_AL)) {
			foreach($_AL as $a) {
				M('Article')->delete_article($a['article_id']);
			}
		}

		if(false === $this->delete($articleCategoryId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		clear_dir(DATA_PATH.D_S.'_acl');
		clear_dir(DATA_PATH.D_S.'_aci');

		return $result;
	}

	public function update_count($articleCategoryId) {
		$result = array('data' => '', 'error' => '');

		$_ACI = $this->get_categoryInfo($articleCategoryId);
		if(empty($_ACI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		$acAC = M('Article')->where(array('article_category_id' => array('IN', implode(',', $_ACI['ac_sub_id'])), 'a_status' => array('EQ', 1)))->count();
		$acRC = M('ArticleReview')->where(array('article_category_id' => array('IN', implode(',', $_ACI['ac_sub_id'])), 'ar_status' => array('EQ', 1)))->count();

		$this->where(array('article_category_id' => array('EQ', $articleCategoryId)))->set_field(array('ac_article_count', 'ac_review_count'), array($acAC, $acRC));

		$result['data'] = array('ac_article_count' => $acAC, 'ac_review_count' => $acRC);

		clear_dir(DATA_PATH.D_S.'_acl');
		clear_dir(DATA_PATH.D_S.'_aci');

		return $result;
	}

	/* step change category article count */
	public function step_article_count($articleCategoryId, $inc = true) {
		$result = array('data' => '', 'error' => '');

		$cid = $articleCategoryId;
		while(0 != $cid) {
			if($inc) {
				$this->field_inc('ac_article_count', array('article_category_id' => array('EQ', $cid)));
			}
			else {
				$this->field_dec('ac_article_count', array('article_category_id' => array('EQ', $cid)));
			}
			$_ci = $this->get_categoryInfo($cid);
			$cid = $_ci['ac_parent_id'];
		}

		clear_dir(DATA_PATH.D_S.'_acl');
		clear_dir(DATA_PATH.D_S.'_aci');

		return $result;
	}

	/* step change category review count */
	public function step_review_count($articleCategoryId, $inc = true) {
		$result = array('data' => '', 'error' => '');

		$cid = $articleCategoryId;
		while(0 != $cid) {
			if($inc) {
				$this->field_inc('ac_review_count', array('article_category_id' => array('EQ', $cid)));
			}
			else {
				$this->field_dec('ac_review_count', array('article_category_id' => array('EQ', $cid)));
			}
			$_ci = $this->get_categoryInfo($cid);
			$cid = $_ci['ac_parent_id'];
		}

		clear_dir(DATA_PATH.D_S.'_acl');
		clear_dir(DATA_PATH.D_S.'_aci');

		return $result;
	}

	/* get category select */
	public function get_categorySelect($_ACL, $articleCategoryId = 0, $selectType = 'current', $exclude = array()) {
		$categorySelect = '';

		$category = new ATree($_ACL, array('article_category_id', 'ac_parent_id', 'ac_sub_category'));

		if('current' == $selectType) {
			/* get sub category when article category id is zero */
			if(0 == $articleCategoryId) {
				$acNav = $category->get_leaf($articleCategoryId);
					$categorySelect .= ' <select class="control-input input-inline">';
					$categorySelect .= '<option value="">----</option>';
				if(!empty($acNav)) {
					foreach($acNav as $acn) {
						if(!empty($exclude) and in_array($acn['article_category_id'], $exclude)) {
							continue;
						}
						$categorySelect .= '<option value="'.$acn['article_category_id'].'">'.$acn['ac_name'].'</option>';
					}
				}
					$categorySelect .= '</select>';
			}
			else {
				$acNav = $category->get_navi($articleCategoryId);
				foreach($acNav as $acn) {
					if(!empty($exclude) and in_array($acn['article_category_id'], $exclude)) {
						break;
					}

					$categorySelect .= ' <select class="control-input input-inline">';
					$categorySelect .= '<option value="">----</option>';

					/* current article category list */
					$_CACL = $category->get_leaf($acn['ac_parent_id']);
					foreach($_CACL as $k => $ac) {
						if(!empty($exclude) and in_array($ac['article_category_id'], $exclude)) {
							continue;
						}
						if(($articleCategoryId == $ac['article_category_id'])
							or ((0 != $articleCategoryId) and ($acn['article_category_id'] == $ac['article_category_id']))) {
							$categorySelect .= '<option value="'.$ac['article_category_id'].'" selected="selected">'.$ac['ac_name'].'</option>';
						}
						else {
							$categorySelect .= '<option value="'.$ac['article_category_id'].'">'.$ac['ac_name'].'</option>';
						}
					}

					$categorySelect .= '</select>';
				}
			}
		}
		elseif('sub' == $selectType) {
			if(!empty($articleCategoryId)) {
				$acNav = $category->get_leaf($articleCategoryId);
				if(!empty($acNav)) {
					$categorySelect .= ' <select class="control-input input-inline">';
					$categorySelect .= '<option value="">----</option>';
					foreach($acNav as $acn) {
						if(!empty($exclude) and in_array($acn['article_category_id'], $exclude)) {
							continue;
						}
						$categorySelect .= '<option value="'.$acn['article_category_id'].'">'.$acn['ac_name'].'</option>';
					}
					$categorySelect .= '</select>';
				}
			}
		}

		return $categorySelect;
	}
}

?>