<?php

/**
 *--------------------------------------
 * article review
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleReviewModl extends Modl {
	public function get_reviewList($where = array(), $order = '`ar_add_time` DESC', $limit = 5, $filter = true) {
		$_ARL = $this->field('__ARTICLE_REVIEW__.*, a.a_title')->join('__ARTICLE__ as a ON a.article_id = __ARTICLE_REVIEW__.article_id')->where($where)->order($order)->limit($limit)->select();

		if(!empty($_ARL)) {
			foreach($_ARL as $k => $v) {
				if($filter and 2 == $v['ar_status']) {
					$_ARL[$k]['ar_author'] = M('Report')->filter_content($v['ar_author']);
					$_ARL[$k]['ar_content'] = M('Report')->filter_content($v['ar_content']);
				}
				$_ARL[$k]['a_url'] = Url::U('home@article/show_article?article_id='.$v['article_id']);
			}
		}
		return $_ARL;
	}

	public function get_reviewInfo($articleReviewId, $parseBR = false) {
		$_ARI = $this->join('__ARTICLE__ as a ON a.article_id = __ARTICLE_REVIEW__.article_id')->where(array('article_review_id' => array('EQ', $articleReviewId)))->find();

		if(!empty($_ARI)) {
			if($parseBR) {
				$_ARI['ar_content'] = str_replace("<br />", "\r\n", $_ARI['ar_content']);
				$_ARI['ar_qoute'] = str_replace("<br />", "\r\n", $_ARI['ar_qoute']);
			}
		}

		return $_ARI;
	}

	public function add_review($data) {
		$result = array('data' => '', 'error' => '');

		unset($data['article_review_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		/* update article review count */
		if(1 == $data['ar_status']) {
			M('Article')->field_inc('a_review_count', array('article_id' => array('EQ', $data['article_id'])));
			M('ArticleCategory')->step_review_count($data['article_category_id']);
		}

		return $result;
	}

	public function edit_review($data) {
		$result = array('data' => '', 'error' => '');

		$_ARI = M('ArticleReview')->field('article_category_id,article_id,ar_status')->where(array('article_review_id' => array('EQ', $data['article_review_id'])))->find();
		if(empty($_ARI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->update($data)) {
			$result['error'] = L('UPDATE_FAILED');
			return $result;
		}

		if(1 != $_ARI['ar_status']) {
			if(1 == $data['ar_status']) {
				M('Article')->field_inc('a_review_count', array('article_id' => array('EQ', $_ARI['article_id'])));
				M('ArticleCategory')->step_review_count($data['article_category_id']);
				if($data['article_category_id'] != $_ARI['article_category_id']) {
					M('ArticleCategory')->step_review_count($_ARI['article_category_id'], false);
				}
			}
		}
		else {
			if(1 != $data['ar_status']) {
				M('Article')->field_dec('a_review_count', array('article_id' => array('EQ', $_ARI['article_id'])));
				M('ArticleCategory')->step_review_count($_ARI['article_category_id'], false);
			}
			else {
				if($data['article_category_id'] != $_ARI['article_category_id']) {
					M('ArticleCategory')->step_review_count($data['article_category_id']);
					M('ArticleCategory')->step_review_count($_ARI['article_category_id'], false);
				}
			}
		}

		return $result;
	}

	public function delete_review($articleReviewId) {
		$result = array('data' => '', 'error' => '');

		$_ARI = M('ArticleReview')->field('article_category_id,article_id,ar_status')->where(array('article_review_id' => array('EQ', $articleReviewId)))->find();
		if(empty($_ARI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->delete($articleReviewId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		if(1 == $_ARI['ar_status']) {
			M('Article')->field_dec('a_review_count', array('article_id' => array('EQ', $_ARI['article_id'])));
			M('ArticleCategory')->step_review_count($articleReviewId, false);
		}

		return $result;
	}

	public function delete_same_ip($articleReviewId) {
		$result = array('data' => '', 'error' => '');

		$_ARI = $this->field('ar_add_ip')->where(array('article_review_id' => array('EQ', $articleReviewId)))->find();
		if(empty($_ARI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->where(array('ar_add_ip' => array('EQ', $_ARI['ar_add_ip'])))->delete()) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}
}

?>