<?php

/**
 *--------------------------------------
 * menu
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-05
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class MenuModl extends Modl {
	public function get_menuList($msAlias = '') {
		$mStatus = intval(ASession::get('m_status'));
		$_ML = F('_menu/_ml_'.$msAlias.'/'.LANG_NAME.'_'.$mStatus);
		if(empty($_ML)) {
			$where = array();
			if(!empty($msAlias)) {
				$where['__MENU__.ms_alias'] = array('EQ', $msAlias);
			}
			$where['__MENU__.lang'] = array('EQ', LANG_NAME);
			$_ML = $this->order('ms.ms_alias ASC, m_display_order ASC')->join('__MENU_SPACE__ AS ms ON ms.ms_alias = __MENU__.ms_alias')->where($where)->select();
			if(!empty($_ML)) {
				foreach($_ML as $k => $m) {
					$_ML[$k]['ms_name'] = unserialize($m['ms_name']);
					$_ML[$k]['ms_description'] = unserialize($m['ms_description']);
					if(MAGIC_QUOTES_GPC) {
						$_ML[$k]['ms_name'] = stripslashes_array($_ML[$k]['ms_name']);
						$_ML[$k]['ms_description'] = stripslashes_array($_ML[$k]['ms_description']);
					}
					$_ML[$k]['ms_name'] = get_itemL($_ML[$k]['ms_name']);
					$_ML[$k]['ms_description'] = get_itemL($_ML[$k]['ms_description']);
				}

				/* get top menu */
				$_T = array();
				foreach($_ML as $k => $menu) {
					if(0 == $menu['m_parent_id']) {
						$menu['url'] = get_url($menu['m_url'], false, $menu['m_type']);
						$menu['url_o'] = get_url($menu['m_url'], true, $menu['m_type']);
						$_T[$menu['menu_id']] = $menu;
						unset($_ML[$k]);
					}
				}
				/* get child menu */
				foreach($_ML as $k => $menu) {
					if(isset($_T[$menu['m_parent_id']])) {
						$menu['url'] = get_url($menu['m_url'], false, $menu['m_type']);
						$menu['url_o'] = get_url($menu['m_url'], true, $menu['m_type']);
						$_T[$menu['m_parent_id']]['m_sub'][] = $menu;
					}
				}
				$_ML = array_values($_T);
				F('_menu/_ml_'.$msAlias.'/'.LANG_NAME.'_'.$mStatus, $_ML);
			}
		}
		return $_ML;
	}

	public function get_menuInfo($menuId) {
		$where = array();
		$where['menu_id'] = array('EQ', $menuId);
		$where['lang'] = array('EQ', LANG_NAME);

		$_MI = $this->where($where)->find();
		return $_MI;
	}

	public function add_menu($data) {
		$result = array('data' => '', 'error' => '');

		$data['lang'] = LANG_NAME;
		unset($data['menu_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		clear_dir(DATA_PATH.D_S.'_menu/_ml_');
		clear_dir(DATA_PATH.D_S.'_menu/_ml_'.$data['ms_alias']);

		return $result;
	}

	public function edit_menu($data) {
		$result = array('data' => '', 'error' => '');

		$_MI = $this->get_menuInfo($data['menu_id']);

		unset($data['lang']);
		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		clear_dir(DATA_PATH.D_S.'_menu/_ml_');
		clear_dir(DATA_PATH.D_S.'_menu/_ml_'.$data['ms_alias']);
		if($_MI['ms_alias'] != $data['ms_alias']) {
			clear_dir(DATA_PATH.D_S.'_menu/_ml_'.$_MI['ms_alias']);
		}

		return $result;
	}

	public function delete_menu($menuId, $checksub = true) {
		$result = array('data' => '', 'error' => '');

		$_MI = $this->where(array('menu_id' => array('EQ', $menuId)))->find();
		if(empty($_MI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if($checksub) {
			$_t_sub = $this->where(array('m_parent_id' => array('EQ', $menuId)))->select();
			if(!empty($_t_sub)) {
				$result['error'] = L('SUB_MENU_EXIST');
				return $result;
			}
		}

		if(false === $this->delete($menuId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		clear_dir(DATA_PATH.D_S.'_menu/_ml_');
		clear_dir(DATA_PATH.D_S.'_menu/_ml_'.$_MI['ms_alias']);

		return $result;
	}
}

?>