<?php

/**
 *--------------------------------------
 * article search
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-13
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class SearchModl extends Modl {
	protected $sphinx;
	protected $_o_p = array();

	public function __construct() {
		$this->autoCheckFields = false;
		parent::__construct();
	}

	public function analysis_keywords($keywords) {
		$keywords = str_replace(array(',', '，', '  '), ' ', $keywords);
		$keywords = explode(' ', $keywords);
		foreach($keywords as $key => $keyword) {
			$keyword = trim($keyword);
			if(!empty($keyword)) {
				$keywords[$key] = $keyword;
			}
			else {
				unset($keywords[$key]);
			}
		}
		return array_slice(array_unique($keywords), 0, 3);
	}

	public function count_article($keywords = array(), $keywordType = 'OR') {
		$where = $this->_get_where($keywords, $keywordType);
		return $rowsNum = M('Article')->get_articleCount($where);
	}

	public function search($keywords = array(), $limit = '0,20', $keywordType = 'OR') {
		$where = $this->_get_where($keywords, $keywordType);
		return M('Article')->get_articleList($where, 'article_id asc', $limit);
	}

	private function _get_where($keywords, $keywordType) {
		$map = array();
		/* keywords */
		$likeArr = array();
		foreach($keywords as $k => $v) {
			$likeArr[] = array('LIKE', '%'.$v.'%');
		}
		$likeArr[] = $keywordType;
		$map['__ARTICLE__.a_title'] = $likeArr;
		$map['__ARTICLE__.a_description'] = $likeArr;
		$map['__ARTICLE__.a_keywords'] = $likeArr;
		$map['_logic'] = 'OR';

		$where = array();
		$where['_complex'] = $map;
		$where['__ARTICLE__.a_status'] = array('EQ', 1);

		return $where;
	}

}

?>