<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}fea/css/fea.g.min.css" />
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}css/calendar.css" />
<link rel="stylesheet" type="text/css" href="{-:*__STYLE__-}css/common.css" />
{-if:'rtl'==_LD_-}
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}fea/css/fea.g.rtl.min.css" />
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}css/calendar-rtl.css" />
<link rel="stylesheet" type="text/css" href="{-:*__STYLE__-}css/common-rtl.css" />
{-:/if-}
<script src="{-:*__RES__-}js/calendar/calendar.js"></script>
<script src="{-:*__RES__-}js/calendar/lang/{-:*LANG_NAME-}.js"></script>
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	EDITOR: {
		BASE_PATH: '{-:*__RES__-}js/editor/',
		PLUGIN_PATH: '{-:*__RES__-}js/editor/plugins/',
		UPLOAD_JSON: '{-url:editorjson/upload-}',
		FILE_MANAGER_JSON: '{-url:editorjson/file_manage-}',
		FORM_DATA : {
			'timeKey' : '{-:$_TK["timeKey"]-}',
			'token' : '{-:$_TK["token"]-}'
		}
	},
	URL : {
		GET_CATEGORY_SELECT : '{-url:admin@article_category/_get_category_select-}',
		GET_CATEGORY_DEFAULT : '{-url:admin@article_category/_get_category_default-}'
	}
};
</script>
</head>

<body>
<div class="container margin">

<form id="formEdit" action="" method="post">
<ul class="subnav subnav-tab" data-switcher="{'connect':'#tabContent'}">
	<li><a href="#">{-:@EDIT_ARTICLE-}</a></li>
	<li><a href="#">{-:@ADDON_FIELD-}</a></li>
	<li><a href="#">{-:@ADVANCE-}</a></li>
</ul>
<div id="tabContent" class="switcher">
	<div class="tabCntnt">
		<table class="formTable margin">
			<tr>
				<td class="inputTitle">{-:@TITLE-}</td>
				<td class="inputTitle">{-:@RANK-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					<input id="a_title" type="text" name="a_title" validate="/\S+/" value="{-:$_AI['a_title']-}" class="control-input input-inline" maxlength="255" size="50"> <span class="text-danger">*</span>
				</td>
				<td class="inputArea">
					<input class="control-input input-inline" type="text" value="{-:$_AI['a_rank']-}" name="a_rank" maxlength="6" size="6">
				</td>
			</tr>
			<tr>
				<td colspan="2" class="inputArea">
					<label><strong>{-:@KEYWORDS-}</strong> <input type="text" name="a_keywords" value="{-:$_AI['a_keywords']-}" class="control-input input-inline" maxlength="255" size="50"></label> <span class="text-muted">{-:@A_KEYWORDS_TIP-}</span>
				</td>
			</tr>
			<tr>
				<td class="inputArea">
					<label><strong>{-:@CATEGORY-}</strong>
					<input id="article_category_id" type="hidden" value="{-:$_AI['article_category_id']-}" name="article_category_id" />
					<span id="article_category_id_category_select" class="category_select" to='#article_category_id' a_field="yes" article_id="{-:$_AI['article_id']-}"></span></label>
					<strong>{-:@FLAG-}</strong> {-foreach:$_AFL,$af,$afn-}<label><input type="checkbox" value="{-:$af-}" name="af_alias[]" {-if:
			in_array($af, $_AI['af_alias'])-} checked="checked"{-:/if-}> {-:$afn|get_itemL-}[{-:$af-}]</label>{-:/foreach-}
				</td>
				<td class="inputTip" rowspan="3">
					<img id="a_thumb_preview" src="{-:$_AI['a_thumb']-}" width="320" data-loadimg="{'loadingImg':'{-:*__APP__-}u/site/default_article_thumb.png', 'errorImg':'{-:*__APP__-}u/site/img_error.png'}" />
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@THUMB-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					<input id="a_thumb" class="control-input input-inline ltr" type="text" value="{-:$_AI['a_thumb']-}" name="a_thumb" maxlength="255" size="40">
					<span id="a_thumb_finder" to="#a_thumb" preview="#a_thumb_preview" class="btn finder" thumb="yes">{-:@BROWSE_SERVER-}</span>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="inputTitle">{-:@PROPERTY-} <span class="btn btn-sm" id="add_property">{-:@ADD_PROPERTY-}</span> <span class="text-muted text-normal">{-:@A_PROPERTY_TIP-}</span></td>
			</tr>
			<tr>
				<td colspan="2" class="inputArea property_set_root">
					<ul id='property_set' class="property_set list-inline">
						{-foreach:$_AI['a_property'],$k,$aps-}<li k="{-:$k-}" class="property_item margin-top-sm margin-right">
							<span class="property_handle icon-bars"></span>
							<input type="text" name="a_property[{-:$k-}][name]" value="{-:$aps['name']-}" size="10" class="control-input input-inline input-sm" placeholder="{-:@PROPERTY_NAME-}" />
							<input type="text" name="a_property[{-:$k-}][value]" value="{-:$aps['value']-}" size="20" class="control-input input-inline input-sm" placeholder="{-:@PROPERTY_VALUE-}" />
							<span class="btn btn-sm delete">{-:@DELETE-}</span>
						</li>{-:/foreach-}
					</ul>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="inputTitle">
					{-:@CONTENT-}
					<span class="text-normal">
						<label><input type="checkbox" name="get_abstract" value="yes"> {-:@GET_ABSTRACT-}</label>
						<label><input type="checkbox" name="delete_external_links" value="yes"> {-:@DELETE_EXTERNAL_LINKS-}</label>
					</span>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="inputArea">
					<textarea class="editor" name="a_content" style="height:240px;">{-:$_AI['a_content']-}</textarea>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="inputTitle">{-:@IMAGE-} <span class="btn btn-sm" id="add_image">{-:@ADD_IMAGE-}</span> <span class="text-muted text-normal">{-:@A_IMAGE_TIP-}</span></td>
			</tr>
			<tr>
				<td colspan="2" class="inputArea image_set_root">
					<div id="image_set" class="image_set row">
						{-foreach:$_AI['a_image'],$k,$ais-}<div k="{-:$k-}" class="image_item width-sm-2-1 placeholder">
							<div class="row">
								<div class="width-sm-2-1">
									<span class="image_handle icon-bars"></span>
									<input id="a_image_{-:$k-}_url" type="hidden" name="a_image[{-:$k-}][url]" value="{-:$ais['url']-}" />
									<span id="a_image_{-:$k-}_url_finder" to="#a_image_{-:$k-}_url" preview="#a_image_{-:$k-}_url_preview" class="btn btn-sm finder" thumb="yes">{-:@BROWSE_SERVER-}</span>
									<span class="btn btn-sm delete">{-:@DELETE-}</span>
									<input type="text" name="a_image[{-:$k-}][title]" value="{-:$ais['title']-}" size="10" class="control-input input-sm margin-top-sm" placeholder="{-:@TITLE-}" />
									<textarea name="a_image[{-:$k-}][description]" class="control-input margin-top-sm" style="height:90px;" placeholder="{-:@DESCRIPTION-}">{-:$ais['description']-}</textarea>
								</div>
								<div class="width-sm-2-1">
									<img id="a_image_{-:$k-}_url_preview" style="max-height:150px" class="thumb" src="{-:$ais['url']-}">
								</div>
							</div>
						</div>{-:/foreach-}
					</div>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@DESCRIPTION-}</td>
				<td class="inputTitle"></td>
			</tr>
			<tr>
				<td class="inputArea">
					<textarea class="control-input input-inline" name="a_description" style="width:480px;height:70px;" placeholder="{-:@A_DESCRIPTION_TIP-}">{-:$_AI['a_description']-}</textarea>
				</td>
				<td class="inputTip">
					{-:@A_DESCRIPTION_TIP-}
				</td>
			</tr>
		</table>
	</div>
	<div class="tabCntnt">
		<table id="a_field_set" class="formTable margin">
		{-foreach:$_AI['ac_addon_field'],$acaf-}
			<tr>
				<td class="inputTitle">{-:$acaf['name']-}</td>
				<td class="inputTitle"></td>
			</tr>
			{-if:'string'==$acaf['type']-}
				<tr>
					<td class="inputArea"><input type="text" name="a_addon_field[{-:$acaf['key']-}]" value="{-:$_AI[$acaf['key']]-}" class="control-input input-inline" maxlength="255" size="40"></td>
					<td class="inputTip">{-:$acaf['tips']-}</td>
				</tr>
			{-elseif:'number'==$acaf['type']-}
				<tr>
					<td class="inputArea"><input type="text" name="a_addon_field[{-:$acaf['key']-}]" value="{-:$_AI[$acaf['key']]-}" class="control-input input-inline" maxlength="20" size="10"></td>
					<td class="inputTip">{-:$acaf['tips']-}</td>
				</tr>
			{-elseif:'bool'==$acaf['type']-}
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="1" name="a_addon_field[{-:$acaf['key']-}]"{-if:1 == $_AI[$acaf['key']]-} checked="checked"{-:/if-}> {-:@YES-}</label>
						<label><input type="radio" value="0" name="a_addon_field[{-:$acaf['key']-}]"{-if:0 == $_AI[$acaf['key']]-} checked="checked"{-:/if-}> {-:@NO-}</label>
					</td>
					<td class="inputTip">{-:$acaf['tips']-}</td>
				</tr>
			{-elseif:'multi_text'==$acaf['type']-}
				<tr>
					<td class="inputArea">
						<textarea class="control-input input-inline" name="a_addon_field[{-:$acaf['key']-}]" style="width:480px;height:70px;">{-:$_AI[$acaf['key']]-}</textarea>
					</td>
					<td class="inputTip">{-:$acaf['tips']-}</td>
				</tr>
			{-elseif:'html_text'==$acaf['type']-}
				<tr>
					<td class="inputArea" colspan="2">
						<textarea class="editor" name="a_addon_field[{-:$acaf['key']-}]" style="height:240px;">{-:$_AI[$acaf['key']]-}</textarea>
						<div class="text-muted">{-:$acaf['tips']-}</div>
					</td>
				</tr>
			{-elseif:'file'==$acaf['type']-}
				<tr>
					<td class="inputArea">
						<input id="a_addon_field_{-:$acaf['key']-}" type="text" name="a_addon_field[{-:$acaf['key']-}]" value="{-:$_AI[$acaf['key']]-}" class="control-input input-inline" maxlength="255" size="50">
						<span id="a_addon_field_{-:$acaf['key']-}_finder" to="#a_addon_field_{-:$acaf['key']-}" class="btn finder" >{-:@BROWSE_SERVER-}</span>
					</td>
					<td class="inputTip">{-:$acaf['tips']-}</td>
				</tr>
			{-:/if-}
		{-:/foreach-}
		</table>
	</div>
	<div class="tabCntnt">
		<table class="formTable margin">
			<tr>
				<td colspan="2" class="inputArea">
					<label><strong>{-:@JUMP_URL-}</strong> <input type="text" name="a_url_jump" value="{-:$_AI['a_url_jump']-}" class="control-input input-inline" maxlength="255" size="50"></label> <span class="text-muted">{-:@A_URL_JUMP_TIP-}</span>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@STATUS-}</td>
				<td class="inputTitle">{-:@REVIEW_SWITCH-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					<label><input type="radio" value="0" name="a_status"{-if:0 == $_AI['a_status']-} checked="checked"{-:/if-}> {-:@NOT_PASSED-}</label>
					<label><input type="radio" value="1" name="a_status"{-if:1 == $_AI['a_status']-} checked="checked"{-:/if-}> {-:@PASSED-}</label>
				</td>
				<td class="inputArea">
					<label><input type="radio" value="0" name="a_review_switch"{-if:0 == $_AI['a_review_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
					<label><input type="radio" value="1" name="a_review_switch"{-if:1 == $_AI['a_review_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@EDIT_TIME-}</td>
				<td class="inputTitle">{-:@TEMPLATE-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					{-:$_AI['a_edit_time']|date~C('APP.TIME_FORMAT'),@me-}
					<input class="control-input input-inline calendar" type="text" value="{-php:echo date(C('APP.TIME_FORMAT'));-}" format="{-:#APP.TIME_FORMAT-}" id="a_edit_time" name="a_edit_time" maxlength="255" size="20">
					<label><input type="checkbox" name="not_upodate_edit_time" value="n"> {-:@NOT_UPDATE_EDIT_TIME-}</label>
				</td>
				<td class="inputArea">
					<div class="input-select" data-input-select="{target: 'input'}">
						<input type="text" name="a_tpl" validate="/\S+/" value="{-:$_AI['a_tpl']|default~'show_article.php'-}" class="control-input input-inline" size="30" maxlength="64">
						<select id="a_tpl" class="control-input input-inline">
							{-foreach:$_TPLS,$tpl-}
							<option value="{-:$tpl['file']-}"{-if:$tpl['file']==$_AI['a_tpl']-} selected="selected"{-:/if-}>{-:$tpl['name']-}</option>
							{-:/foreach-}
						</select>
					</div>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@COUNT-}</td>
				<td class="inputTitle"></td>
			</tr>
			<tr>
				<td colspan="2" class="inputArea">
					<label>{-:@VIEW-} <input type="text" name="a_view_count" validate="/\S+/" value="{-:$_AI['a_view_count']-}" class="control-input input-inline" maxlength="20" size="10"></label>
					<label>{-:@REVIEW-} <input type="text" name="a_review_count" validate="/\S+/" value="{-:$_AI['a_review_count']-}" class="control-input input-inline" maxlength="20" size="10"></label>
					<label>{-:@SUPPORT-} <input type="text" name="a_support_count" validate="/\S+/" value="{-:$_AI['a_support_count']-}" class="control-input input-inline" maxlength="20" size="10"></label>
					<label>{-:@OPPOSE-} <input type="text" name="a_oppose_count" validate="/\S+/" value="{-:$_AI['a_oppose_count']-}" class="control-input input-inline" maxlength="20" size="10"></label>
				</td>
			</tr>
		</table>
	</div>
</div>
<div id="operation" class="margin">
	<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
	<input name="token" type="hidden" value="{-:$_TK['token']-}">
	<input type="hidden" value="{-:$_AI['article_id']-}" name="article_id">
	<span class="btn btn-info submit" action="{-url:admin@article/edit_article_do-}" to="#formEdit">{-:@SUBMIT-}</span>
	<input class="btn" type="reset" value="{-:@RESET-}">
	<a class="btn" href="{-url:admin@article/list_article-}">{-:@BACK-}</a>
</div><!--/#operation-->
</form>

</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__RES__-}js/editor/editor.js"></script>
<script src="{-:*__RES__-}js/editor/lang/{-:*LANG_NAME-}.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/calendar.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
<script src="{-:*__STYLE__-}js/editor.js"></script>
<script src="{-:*__STYLE__-}js/article_category.js"></script>
<script src="{-:*__STYLE__-}js/article.js"></script>
</body>
</html>