<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
{-include:../meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	EDITOR: {
		BASE_PATH: '{-:*__RES__-}js/editor/',
		PLUGIN_PATH: '{-:*__RES__-}js/editor/plugins/',
		UPLOAD_JSON: '{-url:editorjson/upload-}',
		FILE_MANAGER_JSON: '{-url:editorjson/file_manage-}',
		FORM_DATA : {
			'timeKey' : '{-:$_TK["timeKey"]-}',
			'token' : '{-:$_TK["token"]-}'
		}
	},
	URL : {
		GET_CATEGORY_SELECT : '{-url:admin@article_category/_get_category_select-}',
		GET_CATEGORY_DEFAULT : '{-url:admin@article_category/_get_category_default-}'
	}
};
</script>
</head>

<body>
<div class="container margin">

<form id="formEdit" action="" method="post">
<ul class="subnav subnav-tab" data-switcher="{'connect':'#tabContent'}">
	<li><a href="#">{-:@GENERAL-}</a></li>
	<li><a href="#">{-:@CONTENT-}</a></li>
	<li><a href="#">{-:@ADDON_FIELD-}</a></li>
</ul>
<div id="tabContent" class="switcher">
	<div class="tabCntnt">
		<table class="formTable">
			<tr>
				<td class="inputTitle" colspan="2">{-:@NAME-} <span class="text-danger">*</span></td>
			</tr>
			<tr>
				<td class="inputArea" colspan="2">
					<input type="text" name="ac_name" validate="/\S+/" value="{-:$_ACI['ac_name']-}" class="control-input input-inline" maxlength="64" size="30">
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@PARENT_CATEGORY-}</td>
				<td class="inputTitle">{-:@ALIAS-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					<input id="ac_parent_id" type="hidden" value="{-:$_ACI['ac_parent_id']-}" name="ac_parent_id" />
					<span id="ac_parent_id_category_select" class="category_select" to='#ac_parent_id' exclude="{-:$_ACI['article_category_id']-}" ac_field="yes"></span><br />
					<span class="text-muted">{-:@AC_PARENT_ID_TIP-}</span>
				</td>
				<td class="inputArea">
					<input type="text" name="ac_alias" value="{-:$_ACI['ac_alias']-}" class="control-input input-inline" maxlength="64" size="30"><br />
					<span class="text-muted">{-:@AC_ALIAS_TIP-}</span>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@DISPLAY_SWITCH-}</td>
				<td class="inputTitle">{-:@REVIEW_SWITCH-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					<label><input type="radio" value="0" name="ac_display_switch"{-if:0==$_ACI['ac_display_switch']-} checked="checked"{-:/if-}> {-:@HIDDEN-}</label>
					<label><input type="radio" value="1" name="ac_display_switch"{-if:1==$_ACI['ac_display_switch']-} checked="checked"{-:/if-}> {-:@SHOW-}</label>
					<span class="text-muted"><span class="text-danger">*</span> {-:@AC_DISPLAY_SWITCH_TIP-}</span>
				</td>
				<td class="inputArea">
					<label><input type="radio" value="0" name="ac_review_switch"{-if:0==$_ACI['ac_review_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
					<label><input type="radio" value="1" name="ac_review_switch"{-if:1==$_ACI['ac_review_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@PAGE_SIZE-}</td>
				<td class="inputTitle">{-:@DISPLAY_ORDER-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					<input type="text" name="ac_page_size" validate="/\S+/" value="{-:$_ACI['ac_page_size']-}" class="control-input input-inline" size="4" maxlength="5">
					<span class="text-muted"><span class="text-danger">*</span> {-:@AC_PAGE_SIZE_TIP-}</span>
				</td>
				<td class="inputArea">
					<input type="text" name="ac_display_order" validate="/\S+/" value="{-:$_ACI['ac_display_order']-}" class="control-input input-inline" size="4" maxlength="5">
					<span class="text-muted"><span class="text-danger">*</span> {-:@AC_DISPLAY_ORDER_TIP-}</span>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@TEMPLATE-}</td>
				<td class="inputTitle">{-:@ARTICLE_TEMPLATE-}</td>
			</tr>
			<tr>
				<td class="inputArea">
					<div class="input-select" data-input-select="{target: 'input'}">
						<input type="text" name="ac_tpl" validate="/\S+/" value="{-:$_ACI['ac_tpl']-}" class="control-input input-inline" size="30" maxlength="64">
						<select id="ac_tpl" class="control-input input-inline">
							{-foreach:$_TPLS,$tpl-}
							<option value="{-:$tpl['file']-}"{-if:$tpl['file']==$_ACI['ac_tpl']-} selected="selected"{-:/if-}>{-:$tpl['name']-}</option>
							{-:/foreach-}
						</select>
					</div>
					<span class="text-muted"><span class="text-danger">*</span> {-:@AC_TPL_TIP-}</span>
				</td>
				<td class="inputArea">
					<div class="input-select" data-input-select="{target: 'input'}">
						<input type="text" name="ac_a_tpl" validate="/\S+/" value="{-:$_ACI['ac_a_tpl']-}" class="control-input input-inline" size="30" maxlength="64">
						<select class="control-input input-inline">
							{-foreach:$_TPLS,$tpl-}
							<option value="{-:$tpl['file']-}"{-if:$tpl['file']==$_ACI['ac_a_tpl']-} selected="selected"{-:/if-}>{-:$tpl['name']-}</option>
							{-:/foreach-}
						</select>
					</div>
					<span class="text-muted"><span class="text-danger">*</span> {-:@AC_ARTICLE_TPL_TIP-}</span>
				</td>
			</tr>
		</table>
	</div>
	<div class="tabCntnt">
		<table class="formTable">
			<tr>
				<td class="inputTitle">{-:@CATEGORY_THUMB-}</td>
				<td class="inputTip" rowspan="6" valign="top">
				{-if:!empty($_ACI['ac_thumb'])-}
					<img id="ac_thumb_preview" src="{-:$_ACI['ac_thumb']-}" />
				{-else:-}
					<img id="ac_thumb_preview" src="{-:*__APP__-}u/site/default_category_thumb.png" />
				{-:/if-}
				</td>
			</tr>
			<tr>
				<td class="inputArea">
					<input id="ac_thumb" type="text" name="ac_thumb" value="{-:$_ACI['ac_thumb']-}" class="control-input input-inline ltr" maxlength="255" size="50">
					<span id="ac_thumb_finder" to="#ac_thumb" preview="#ac_thumb_preview" typeset='image' class="btn finder">{-:@BROWSE_SERVER-}</span>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@KEYWORDS-}</td>
				<td class=""></td>
			</tr>
			<tr>
				<td class="inputArea">
					<textarea class="control-input" name="ac_keywords" style="width:360px;height:40px;">{-:$_ACI['ac_keywords']-}</textarea> <span class="text-muted">{-:@AC_KEYWORDS_TIP-}</span>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@DESCRIPTION-}</td>
				<td class=""></td>
			</tr>
			<tr>
				<td class="inputArea">
					<textarea class="control-input" name="ac_description" style="width:480px;height:70px;">{-:$_ACI['ac_description']-}</textarea> <span class="text-muted">{-:@AC_DESCRIPTION_TIP-}</span>
				</td>
			</tr>
			<tr>
				<td class="inputTitle">{-:@CONTENT-} <span class="text-muted text-normal">{-:@AC_CONTENT_TIP-}</span></td>
				<td class=""></td>
			</tr>
			<tr>
				<td class="inputArea" colspan="2">
					<textarea class="editor" name="ac_content" style="height:180px;">{-:$_ACI['ac_content']-}</textarea>
				</td>
			</tr>
		</table>
	</div>
	<div class="tabCntnt">
		<table id="field_set" class="table table-hover field_set_root">
			<tbody class="field_set">
				<tr>
					<th><span class="btn btn-sm create_field">{-:@ADD_FIELD-}</span></th>
					<th scope="col">{-:@KEY-}</th>
					<th scope="col">{-:@NAME-}</th>
					<th scope="col">{-:@TYPE-}</th>
					<th scope="col">{-:@TIPS-}</th>
					<th scope="col">{-:@MANAGE-}</th>
				</tr>
			{-foreach:$_ACI['ac_addon_field'],$k,$acaf-}
				<tr class="field_item" k="{-:$k-}">
					<td class="field_handle tree-sortable-handle"><i class="icon-bars"></i></td>
					<td><input type="text" name="ac_addon_field[{-:$k-}][key]" value="{-:$acaf['key']-}" validate="/\S+/" class="control-input input-sm" maxlength="32" size="10"></td>
					<td><input type="text" name="ac_addon_field[{-:$k-}][name]" value="{-:$acaf['name']-}" validate="/\S+/" class="control-input input-sm" maxlength="32" size="18"></td>
					<td>
						<select class="control-input input-inline input-sm" name="ac_addon_field[{-:$k-}][type]">
							<option {-if:'string'==$acaf['type']-} selected="selected"{-:/if-} value="string">{-:@STRING-}</option>
							<option {-if:'number'==$acaf['type']-} selected="selected"{-:/if-} value="number">{-:@NUMBER-}</option>
							<option {-if:'bool'==$acaf['type']-} selected="selected"{-:/if-} value="bool">{-:@BOOLEAN-}</option>
							<option {-if:'multi_text'==$acaf['type']-} selected="selected"{-:/if-} value="multi_text">{-:@MULTI_TEXT-}</option>
							<option {-if:'html_text'==$acaf['type']-} selected="selected"{-:/if-} value="html_text">{-:@HTML_TEXT-}</option>
							<option {-if:'file'==$acaf['type']-} selected="selected"{-:/if-} value="file">{-:@FILE-}</option>
						</select>
					</td>
					<td><input type="text" name="ac_addon_field[{-:$k-}][tips]" value="{-:$acaf['tips']-}" class="control-input input-sm" maxlength="64" size="24"></td>
					<td><span class="btn btn-sm delete_field">{-:@DELETE-}</span></td>
				</tr>
			{-:/foreach-}
			</tbody>
		</table>
	</div>
</div>
<div id="operation" class="margin">
	<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
	<input name="token" type="hidden" value="{-:$_TK['token']-}">
	<input type="hidden" value="{-:$_ACI['article_category_id']-}" name="article_category_id">
	<span class="btn btn-info submit" action="{-url:admin@article_category/edit_category_do-}" to="#formEdit">{-:@SUBMIT-}</span>
	<input class="btn" type="reset" value="{-:@RESET-}">
	<a class="btn" href="{-url:admin@article_category/list_category-}">{-:@BACK-}</a>
</div><!--/#operation-->
</form>

</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__RES__-}js/editor/editor.js"></script>
<script src="{-:*__RES__-}js/editor/lang/{-:*LANG_NAME-}.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
<script src="{-:*__STYLE__-}js/editor.js"></script>
<script src="{-:*__STYLE__-}js/article_category.js"></script>
</body>
</html>