<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
{-include:../meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}'
};
</script>
</head>

<body>
<div class="container margin">

<ul class="subnav subnav-tab">
	<li class="active"><a href="#">{-:@FILE_LIST-}</a></li>
</ul>
<div id="tabContent">
	{-if:empty($_FL)-}
		<div class="placeholder text-center margin">{-:@LIST_EMPTY-}</div>
	{-else:-}
		<table class="table table-hover">
			<tr>
				<td colspan="5">
					<span class="text-strong">{-:@CURRENT_DIR-}: </span>
					<span class="badge">{-:$_O['dir']-}{-:$_FL['current_dir']|str_replace~'\*','\/',@me-}</span>
				</td>
			</tr>
			<tr>
				<th scope="col">{-:@NAME-}</th>
				<th scope="col">{-:@TYPE-}</th>
				<th scope="col">{-:@SIZE-}</th>
				<th scope="col">{-:@EDIT_TIME-}</th>
				<th scope="col">{-:@MANAGE-}</th>
			</tr>
			{-if:!empty($_FL['current_dir'])-}<tr>
				<td colspan="5"><i class="icon-lg icon-folder-open"></i> <a href="{-url:admin@file_explore/list_file?dir={$_FL['parent_dir']}-}">.. [{-:@PARENT_DIR-}]</a></td>
			</tr>{-:/if-}
		{-if:empty($_FL['list']['dir']) and empty($_FL['list']['file'])-}
			<tr>
				<td colspan="5"><div class="listEmptyTips">{-:@LIST_EMPTY-}</div></td>
			</tr>
		{-else:-}
			{-foreach:$_FL['list']['dir'],$dir-}
			<tr>
				<td><i class="icon-lg icon-folder"></i> <a href="{-url:admin@file_explore/list_file?dir={$_FL['current_dir']}*{$dir['name']}-}">{-:$dir['name']-}</a></td>
				<td>
					{-:@DIRECTORY-}
				</td>
				<td></td>
				<td></td>
				<td>
					<a class="delete_confirm mLink" href="{-url:admin@file_explore/delete_dir_do?dir={$_FL['current_dir']}&dirname={$dir['name']}&timeKey={$_TK['timeKey']}&token={$_TK['token']}-}">{-:@DELETE-}</a>
				</td>
			</tr>
			{-:/foreach-}
			{-foreach:$_FL['list']['file'],$file-}
			<tr>
				<td><i class="icon-lg
				{-if:in_array($file['type']['alias'], array('image'))-}
					icon-file-image
				{-elseif:in_array($file['type']['alias'], array('audio'))-}
					icon-file-audio
				{-elseif:in_array($file['type']['alias'], array('video'))-}
					icon-file-video
				{-elseif:in_array($file['type']['alias'], array('style_sheet', 'script'))-}
					icon-file-code
				{-elseif:in_array($file['type']['alias'], array('text', 'web_page'))-}
					icon-file-text
				{-elseif:in_array($file['type']['alias'], array('compressed'))-}
					icon-file-zip
				{-else:-}
					icon-file-o
				{-:/if-}
				"></i> {-:$file['name']-}</td>
				<td>{-:$file['type']['name']-}</td>
				<td>{-:$file['size']-}</td>
				<td>{-:$file['edit_time']-}</td>
				<td>
				{-if:'image'==$file['type']['alias']-}
					<span class="pointer" data-dialog="{id:'{-:$file['url']|md5-}',width:'400',title:'{-:@PREVIEW-}',content:'<img src={-:$file['url']-}>'}"><i class="icon-lg icon-zoom-in"></i></span>
				{-:/if-}
					<a target="_blank" href="{-:$file['url']-}" download>{-:@DOWNLOAD-}</a> |
					<a class="delete_confirm" href="{-url:admin@file_explore/delete_file_do?dir={$_FL['current_dir']}&file={$file['name']}&timeKey={$_TK['timeKey']}&token={$_TK['token']}-}">{-:@DELETE-}</a>
				</td>
			</tr>
			{-:/foreach-}
		{-:/if-}
		</table>
	{-:/if-}
</div>
<div id="operation" class="margin">
	<form id="formFileExplore" class="form" method="post" action="" enctype="multipart/form-data">
		<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
		<input name="token" type="hidden" value="{-:$_TK['token']-}">
		<input name="dir" type="hidden" value="{-:$_FL['current_dir']-}" />
		<div class="form-group">
			<input type="text" name="dirname" class="control-input input-inline" size="30" placeholder="{-:@DIRECTORY_NAME-}">
			<span to="#formFileExplore" action="{-url:admin@file_explore/add_dir_do-}" class="btn btn-default submit">{-:@ADD_DIR-}</span>
		</div>
		<div class="form-group">
			<div class="input-file" data-input-file="{target: '>input:first'}">
				<input type="text" class="control-input input-inline" size="40" disabled="disabled" placeholder="{-:@SELECT_FILE-}">
				<input type="file" name="uploadFile">
			</div>
			<span to="#formFileExplore" action="{-url:admin@file_explore/upload_file_do-}" class="btn btn-default submit">{-:@UPLOAD_FILE-}</span>
		</div>
	</form>
</div><!--/#operation-->

</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
</body>
</html>