<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
{-include:../meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	EDITOR: {
		BASE_PATH: '{-:*__RES__-}js/editor/',
		PLUGIN_PATH: '{-:*__RES__-}js/editor/plugins/',
		UPLOAD_JSON: '{-url:editorjson/upload-}',
		FILE_MANAGER_JSON: '{-url:editorjson/file_manage-}',
		FORM_DATA : {
			'timeKey' : '{-:$_TK["timeKey"]-}',
			'token' : '{-:$_TK["token"]-}'
		}
	}
};
</script>
</head>

<body>
<div class="container margin">

<form id="formEdit" action="" method="post">
<ul class="subnav subnav-tab">
	<li class="active"><a href="#">{-:@EDIT_FLINK-}</a></li>
</ul>
<div id="tabContent">
	<table class="formTable margin">
		<tr>
			<td class="inputTitle">{-:@CATEGORY-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<select name="fc_alias" class="control-input input-inline">
				{-foreach:$_FCL,$fc-}
					<option value="{-:$fc['fc_alias']-}"{-if:$_FI['fc_alias']==$fc['fc_alias']-} selected="selected"{-:/if-}>{-:$fc['fc_name']-}</option>
				{-:/foreach-}
				</select>
			</td>
			<td class="inputTip">
				<span class="text-muted">{-:@FLINK_CATEGORY_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@SITE_NAME-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input type="text" name="f_site_name" validate="/\S+/" value="{-:$_FI['f_site_name']-}" class="control-input input-inline" maxlength="96" size="30">
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@F_SITE_NAME_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@SITE_URL-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input type="text" name="f_site_url" validate="/\S+/" value="{-:$_FI['f_site_url']-}" class="control-input input-inline ltr" maxlength="96" size="30">
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@F_SITE_URL_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@WEBMASTER_EMAIL-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input class="control-input input-inline" type="text" value="{-:$_FI['f_webmaster_email']-}" name="f_webmaster_email" maxlength="96" size="30">
			</td>
			<td class="inputTip">
				<span class="text-muted">{-:@F_WEBMASTER_EMAIL_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@SITE_DESCRIPTION-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<textarea class="control-input input-inline" name="f_site_description" style="width:480px;height:70px;">{-:$_FI['f_site_description']-}</textarea>
			</td>
			<td class="inputTip">
				<span class="text-muted">{-:@F_SITE_DESCRIPTION_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@SITE_LOGO-}</td>
			<td rowspan="2" class="inputArea">
			{-if:!empty($_FI['f_site_logo'])-}
				<img id="f_site_logo_preview" src="{-:$_FI['f_site_logo']-}" />
			{-else:-}
				<img id="f_site_logo_preview" src="{-:*__APP__-}u/flink/no_flink_logo.png" />
			{-:/if-}
			</td>
		</tr>
		<tr>
			<td class="inputArea">
				<input id="f_site_log" class="control-input input-inline ltr" type="text" value="{-:$_FI['f_site_logo']-}" name="f_site_logo" maxlength="255" size="50">
				<span id="f_site_logo_finder" to="#f_site_log" preview="#f_site_logo_preview" class="btn finder">{-:@BROWSE_SERVER-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@SHOW_TYPE-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<label><input type="radio" value="0" name="f_show_type"{-if:0==$_FI['f_show_type']-} checked="checked"{-:/if-}> {-:@TEXT_LINK-}</label>
				<label><input type="radio" value="1" name="f_show_type"{-if:1==$_FI['f_show_type']-} checked="checked"{-:/if-}> {-:@LOGO_LINK-}</label>
			</td>
			<td class="inputArea">
				<span class="text-muted">{-:@F_SHOW_TYPE_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@STATUS-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<label><input type="radio" value="0" name="f_status"{-if:0==$_FI['f_status']-} checked="checked"{-:/if-}> {-:@NOT_PASSED-}</label>
				<label><input type="radio" value="1" name="f_status"{-if:1==$_FI['f_status']-} checked="checked"{-:/if-}> {-:@PASSED-}</label>
			</td>
			<td class="inputArea">
				<span class="text-muted">{-:@F_STATUS_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@DISPLAY_ORDER-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input class="control-input input-inline" type="text" value="{-:$_FI['f_display_order']-}" name="f_display_order" maxlength="20" size="10">
			</td>
			<td class="inputArea">
				<span class="text-muted">{-:@F_DISPLAY_ORDER_TIP-}</span>
			</td>
		</tr>
	</table>
</div>
<div id="operation" class="margin">
	<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
	<input name="token" type="hidden" value="{-:$_TK['token']-}">
	<input type="hidden" value="{-:$_FI['flink_id']-}" name="flink_id">
	<span class="btn btn-info submit" action="{-url:admin@flink/edit_flink_do-}" to="#formEdit">{-:@SUBMIT-}</span>
	<input class="btn" type="reset" value="{-:@RESET-}">
	<a class="btn" href="{-url:admin@flink/list_flink-}">{-:@BACK-}</a>
</div><!--/#operation-->
</form>

</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__RES__-}js/editor/editor.js"></script>
<script src="{-:*__RES__-}js/editor/lang/{-:*LANG_NAME-}.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
<script src="{-:*__STYLE__-}js/editor.js"></script>
</body>
</html>