<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:$_SITE['name']-}</title>
<meta name="keywords" content="{-:$_SITE['keywords']-}" />
<meta name="description" content="{-:$_SITE['description']-}" />
{-include:clip/meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}'
};
</script>
</head>
<body>
{-include:clip/header_index-}

<div class="panel panel-info margin">
	<div class="panel-heading"><i class="icon-bookmark"></i> {-:@LIST-}</div>
	<div class="panel-body">
	{-if:empty($_L)-}
		<div class="placeholder placeholder-lg text-center">{-:@LIST_EMPTY-}</div>
	{-else:-}
		<div id="articleList">
			{-foreach:$_L,$k,$item-}
				<article class="article">
					<h1 class="article-title"><a href="{-:$item['a_url']-}">{-:$item['a_title']-}</a></h1>
					<p class="article-meta">
						<span class="attr">{-:@PUBLISH_TIME-}: {-:$item['a_edit_time']|date~C('APP.TIME_FORMAT'),@me-}</span>
						<span class="attr">{-:@VIEW-}: {-:$item['a_view_count']-}</span>
						<span class="attr">{-:@CATEGORY-}: {-if:!empty($item['ac_url'])-}<a href="{-:$item['ac_url']-}">{-:$item['ac_name']-}</a>{-else:-}{-:$item['ac_name']-}{-:/if-}</span>
					</p>
				{-if:!empty($item['a_thumb'])-}
					<img class="" src="{-:$item['a_thumb']-}" data-loadimg="{'loadingImg':'{-:*__APP__-}u/site/default_article_thumb.png'}" />
				{-elseif:!empty($item['a_image'])-}
					<div data-carousel="{autoPlay: 3000, lazyLoad : true, singleItem: true}">
						{-foreach:$item['a_image'],$aik,$aiv-}
							<img class="lazyCarousel" data-src="{-:$aiv['url']-}" />
						{-:/foreach-}
					</div>
				{-:/if-}
					<p>{-:$item['a_description']-}</p>
					<p>
						<a href="{-:$item['a_url']-}" class="btn btn-info">{-:@VIEW_DETAIL-}</a>
						{-if:0<$item['a_review_count']-}<a href="{-url:home@article_review/list_review?article_id={$item['article_id']}-}" class="btn">{-:@NUM_OF_REVIEW_COUNT|count~$item['a_review_count']-}</a>{-:/if-}
					</p>
				</article>
				<hr>
			{-:/foreach-}
		</div>
		<!--next page-->
		{-if:!empty($_PG['nextPage']['url'])-}
			<span id="viewMore" to="#articleList" nextpage="{-:$_PG['nextPage']['url']-}" class="btn btn-block">{-:@VIEW_MORE-} <i class="icon-angle-double-down"></i></span>
		{-:/if-}
	{-:/if-}
	</div>
</div>

{-include:clip/hrp-}

<div class="panel">
	<div class="panel-heading">
		<i class="icon-link"></i> {-:@FLINK-}
	</div>
	<div class="panel-body">
		<ul class="list-inline">
			<loga:fl_list row="5">
			<li><i class="icon-square text-muted"></i> <a target="_blank" href="{-:$item['f_site_url']-}">{-:$item['f_site_name']-}</a></li>
			</loga:fl_list>
		</ul>
	</div>
</div>

{-include:clip/footer-}
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__STYLE__-}mobile/js/common.js"></script>
{-:$_SITE['stat_code']-}
</body>
</html>