<?php

/**
 *--------------------------------------
 * paging
 *--------------------------------------
 * @project		: pfa
 * @author		: cblee
 * @created		: 2012-9-24
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class APage {
	protected $pageSize = 20; // rows per page
	protected $nearSize = 3; // nearsize to show
	protected $pageUrl = ''; // page base url
	protected $totalPages; // total page
	protected $totalRows; // total row
	protected $currentPage; // current page

	public function __construct($totalRows, $pageSize = '', $pageUrl = '', $nearSize = '') {
		$this->totalRows = abs(intval($totalRows));
		if(!empty($pageSize)) {
			$this->pageSize = abs(intval($pageSize));
		}
		if(!empty($nearSize)) {
			$this->nearSize = abs(intval($nearSize));
		}
		if(!empty($pageUrl)) {
			$this->pageUrl = $pageUrl;
		}
		$this->totalPages = 0 < $this->totalRows ? ceil($this->totalRows / $this->pageSize) : 1;

		$_GET[C('VAR.PAGE')] = isset($_GET[C('VAR.PAGE')]) ? intval($_GET[C('VAR.PAGE')]) : 1;
		if($_GET[C('VAR.PAGE')] > $this->totalPages or $_GET[C('VAR.PAGE')] <= 0) {
			halt('', true, true);
		}
		$this->currentPage = $_GET[C('VAR.PAGE')];
	}

	public function __get($name) {
		return isset($this->$name) ? $this->$name : '';
	}

	public function get_paging() {
		$paging = array();

		if(0 == $this->totalRows) {
			return $paging;
		}
		/* first and last page */
		if(1 == $this->currentPage) {
			$paging['firstPage'] = array('page' => 1, 'url' => '');
		}
		else {
			$paging['firstPage'] = array('page' => 1, 'url' => $this->_get_pageUrl(1));
		}
		if($this->totalPages == $this->currentPage) {
			$paging['lastPage'] = array('page' => $this->totalPages, 'url' => '');
		}
		else {
			$paging['lastPage'] = array('page' => $this->totalPages, 'url' => $this->_get_pageUrl($this->totalPages));
		}
		/* previous and next page */
		$prevPage = $this->currentPage - 1;
		$nextPage = $this->currentPage + 1;
		if($prevPage > 0) {
			$paging['prevPage'] = array('page' => $prevPage, 'url' => $this->_get_pageUrl($prevPage));
		}
		else {
			$paging['prevPage'] = array('page' => $prevPage, 'url' => '');
		}
		if($nextPage <= $this->totalPages) {
			$paging['nextPage'] = array('page' => $nextPage, 'url' => $this->_get_pageUrl($nextPage));
		}
		else {
			$paging['nextPage'] = array('page' => $nextPage, 'url' => '');
		}
		/* current page and nearpage */
		$currentPage = '';
		for($i = $this->nearSize; $i > 0; $i--) {
			$_p = $this->currentPage - $i;
			if($_p > 0) {
				$paging['nearPrevPage'][] = array('page' => $_p, 'url' => $this->_get_pageUrl($_p));
			}
		}
		$paging['currentPage'] = array('page' => $this->currentPage, 'url' => $this->_get_pageUrl($this->currentPage));
		for($i = 1; $i < $this->nearSize + 1; $i++) {
			$_p = $this->currentPage + $i;
			if($_p <= $this->totalPages) {
				$paging['nearNextPage'][] = array('page' => $_p, 'url' => $this->_get_pageUrl($_p));
			}
		}
		$paging['totalPages'] = $this->totalPages;
		$paging['totalRows'] = $this->totalRows;

		return $paging;
	}

	/* get limit string */
	public function get_limit() {
		return ($this->currentPage - 1) * $this->pageSize.','.$this->pageSize;
	}

	/* get paging url */
	private function _get_pageUrl($page) {
		return str_replace("_page_", $page, $this->pageUrl);
	}
}

/*---------------------------------------------------------*
$p = new APage($rowsNum, $pageSize, '?page=_page_'); //for parameter
$p = new APage($rowsNum, $pageSize, 'list-_page_.html'); //for html
$_PG = $p->get_paging();
$limit = $p->get_limit();
*/

?>