/** article category */
(function ($, LOGA) {

$(document).ready(function() {
	$('.category_select').each(function() {
		var container_id = $(this).attr('id'),
			article_category_id = $($(this).attr('to')).val(),
			exclude = $(this).attr('exclude');
		LOGA.util.get_category_select(container_id, article_category_id, 'current', exclude);
	});
});

$(document).on('change', '.category_select select', function() {
	$(this).nextAll().remove();
	var container_id = $(this).parent().attr('id'),
		article_category_id = $(this).val(),
		exclude = $(this).parent().attr('exclude'),
		ac_field = $(this).parent().attr('ac_field')||'',
		a_field = $(this).parent().attr('a_field')||'',
		article_id = $(this).parent().attr('article_id')||0;

	if('' != article_category_id) {
		LOGA.util.get_category_select(container_id, article_category_id, 'sub', exclude);
		article_category_id = $(this).parent().children().last().val();
	}
	else {
		var _cv = $(this).parent().children().eq(-2).val();
		article_category_id = (1 != $(this).parent().children().length ^ '' == _cv) ? _cv : 0;
	}

	$($(this).parent().attr('to')).val(article_category_id);

	//get default setting
	if('yes' == ac_field || 'yes' == a_field) {
		$.getJSON(GV.URL.GET_CATEGORY_DEFAULT + '&article_category_id=' + article_category_id + '&article_id=' + article_id  + '&' + Math.random(), function(result) {
			if(1 == result.data) {
				$('input[name="ac_tpl"]').val(result.info['ac_tpl']);
				$('input[name="ac_a_tpl"]').val(result.info['a_tpl']);
				$('input[name="a_tpl"]').val(result.info['a_tpl']);
				//get addon field for category
				var af = result.info['addon_field'];
				if('yes' == ac_field) {
					$('#field_set tr.field_item').remove();
					for(var i in af) {
						create_field(af[i]['key'], af[i]['name'], af[i]['type'], af[i]['tips']);
					}
				}

				//get addon field for article
				if('yes' == a_field) {
					$('#a_field_set tr').remove();
					for(var i in af) {
						create_field_form(af[i]['key'], af[i]['name'], af[i]['type'], af[i]['tips'], af[i]['value']);
					}
				}
			}
			else if('' != result.info) {
				//alert(result.info);
			}
		});
	}
});

/* get article category select */
LOGA.util.get_category_select = function(container_id, article_category_id, select_type, exclude) {
	exclude = exclude||'';
	$.getJSON(GV.URL.GET_CATEGORY_SELECT + '&article_category_id=' + article_category_id + '&select_type=' + select_type + '&exclude=' + exclude + '&' + Math.random(), function(result) {
		if(1 == result.data) {
			if('sub' == select_type) {
				$('#' + container_id).append(result.info);
			}
			else if('current' == select_type) {
				$('#' + container_id).html(result.info);
			}
		}
		else if('' != result.info) {
			//alert(result.info);
		}
	});
}

/* field set */
var option = {
	maxDepth: 1,
	rootClass: 'field_set_root',
	listClass: 'field_set',
	itemClass: 'field_item',
	handleClass: 'field_handle',
	listNodeName: 'tbody',
	itemNodeName: 'tr'
};
$(document).on('click', '.create_field', function() {
	create_field();
})
.on('click', '.delete_field', function() {
	$(this).parent().parent().remove();
});

$('.field_set_root').tree(option);

function create_field(fieldKey, fieldName, fieldType, fieldTips) {
	var fieldStr = '',
		k;
	if(0 == $('#field_set tr.field_item').length) {
		k = 0;
	}
	else {
		k = Number($('#field_set tr:last').attr('k')) + 1;
	}

	fieldKey = fieldKey || '';
	fieldName = fieldName || '';
	fieldType = fieldType || 'string';
	fieldTips = fieldTips || '';

	fieldStr = '<tr class="field_item" k="'+k+'">';
	fieldStr += '	<td class="field_handle tree-sortable-handle"><i class="icon-bars"></i></td>';
	fieldStr += '	<td><input type="text" name="ac_addon_field['+k+'][key]" value="'+fieldKey+'" validate="/\\S+/" class="control-input input-sm" maxlength="32" size="10"></td>';
	fieldStr += '	<td><input type="text" name="ac_addon_field['+k+'][name]" value="'+fieldName+'" validate="/\\S+/" class="control-input input-sm" maxlength="32" size="18"></td>';
	fieldStr += '	<td><select class="control-input input-inline input-sm" name="ac_addon_field['+k+'][type]">';
	fieldStr += '		<option value="string">' + LOGA.L('STRING') + '</option>';
	fieldStr += '		<option value="number">' + LOGA.L('NUMBER') + '</option>';
	fieldStr += '		<option value="bool">' + LOGA.L('BOOLEAN') + '</option>';
	fieldStr += '		<option value="multi_text">' + LOGA.L('MULTI_TEXT') + '</option>';
	fieldStr += '		<option value="html_text">' + LOGA.L('HTML_TEXT') + '</option>';
	fieldStr += '		<option value="file">' + LOGA.L('FILE') + '</option>';
	fieldStr += '	</select></td>';
	fieldStr += '	<td><input type="text" name="ac_addon_field['+k+'][tips]" value="'+fieldTips+'" class="control-input input-sm" maxlength="64" size="24"></td>';
	fieldStr += '	<td><span class="btn btn-sm delete_field">' + LOGA.L('DELETE') + '</span></td>';
	fieldStr += '</tr>';
	$('#field_set').append(fieldStr);

	$('#field_set tr.field_item[k="'+k+'"] select option[value="' + fieldType + '"]').attr('selected','selected');
}

function create_field_form(fieldKey, fieldName, fieldType, fieldTips, fieldValue) {
	fieldValue = fieldValue || '';

	var str = '<tr><td class="inputTitle">'+fieldName+'</td><td class="inputTitle"></td></tr>';
	str += '<tr>';
	if('string' == fieldType) {
		str += '<td class="inputArea"><input type="text" name="a_addon_field['+fieldKey+']" value="'+fieldValue+'" class="control-input input-inline" maxlength="255" size="40"></td>';
		str += '<td class="inputTip">'+fieldTips+'</td>';
	}
	else if('number' == fieldType) {
		str += '<td class="inputArea"><input type="text" name="a_addon_field['+fieldKey+']" value="'+fieldValue+'" class="control-input input-inline" maxlength="20" size="10"></td>';
		str += '<td class="inputTip">'+fieldTips+'</td>';
	}
	else if('bool' == fieldType) {
		if(1 == fieldValue) {
			str += '<td class="inputArea"><label><input type="radio" value="1" name="a_addon_field['+fieldKey+']" checked="checked"> ' + LOGA.L('YES') + '</label>';
			str += '<label><input type="radio" value="0" name="a_addon_field['+fieldKey+']"> ' + LOGA.L('NO') + '</label></td>';
		}
		else {
			str += '<td class="inputArea"><label><input type="radio" value="1" name="a_addon_field['+fieldKey+']"> ' + LOGA.L('YES') + '</label>';
			str += '<label><input type="radio" value="0" name="a_addon_field['+fieldKey+']" checked="checked"> ' + LOGA.L('NO') + '</label></td>';
		}
		str += '<td class="inputTip">'+fieldTips+'</td>';
	}
	else if('multi_text' == fieldType) {
		str += '<td class="inputArea"><textarea class="control-input input-inline" name="a_addon_field['+fieldKey+']" style="width:480px;height:70px;">'+fieldValue+'</textarea></td>';
		str += '<td class="inputTip">'+fieldTips+'</td>';
	}
	else if('html_text' == fieldType) {
		str += '<td class="inputArea" colspan="2"><textarea class="editor" name="a_addon_field['+fieldKey+']" style="height:240px;">'+fieldValue+'</textarea>';
		str += '<div class="text-muted">'+fieldTips+'</div></td>';
	}
	else if('file' == fieldType) {
		str += '<td class="inputArea"><input id="a_addon_field_'+fieldKey+'" type="text" name="a_addon_field['+fieldKey+']" value="'+fieldValue+'" class="control-input input-inline" maxlength="255" size="50">';
		str += '<span id="a_addon_field_'+fieldKey+'_finder" to="#a_addon_field_'+fieldKey+'" class="btn finder" > '+LOGA.L('BROWSE_SERVER')+'</span></td>';
		str += '<td class="inputTip">'+fieldTips+'</td>';
	}

	str += '</tr>';
	$('#a_field_set').append(str);
	KindEditor.create('.editor', GV.EDITOR.OPTIONS);
}

})(jQuery, LOGA);
