/** editor */
(function ($, LOGA) {

var editor;
GV.EDITOR.OPTIONS = {
		basePath : GV.EDITOR.BASE_PATH,
		langType : GV.LANG_NAME,
		width : '100%',
		height : '320px',
		items : [
			'source', '|', 'undo', 'redo', '|', 'preview', 'print', 'code', 'cut', 'copy', 'paste',
			'plainpaste', 'wordpaste', '|', 'justifyleft', 'justifycenter', 'justifyright',
			'justifyfull', 'insertorderedlist', 'insertunorderedlist', 'indent', 'outdent', 'subscript',
			'superscript', 'clearhtml', '/',
			'formatblock', 'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold',
			'italic', 'underline', 'strikethrough', 'removeformat', '|', 'image', 
			'flash', 'media', 'insertfile', 'table', 'emoticons', 'baidumap', 'logapager',
			'anchor', 'link', 'unlink', '|', 'fullscreen'
		],
		//resizeType : 1,
		uploadJson : GV.EDITOR.UPLOAD_JSON,
		fileManagerJson : GV.EDITOR.FILE_MANAGER_JSON,
		extraFileUploadParams : GV.EDITOR.FORM_DATA,
		allowFileManager : true,
		newlineTag : 'p',
		themeType : 'loga',
		afterCreate : function() {
			this.loadPlugin('autoheight');
		},
		afterBlur: function(){
			this.sync();
		}
	};
KindEditor.ready(function(K) {
	editor = K.create('.editor', GV.EDITOR.OPTIONS);
});

$(document).on('click', '.finder', function() {
	var to_id = $(this).attr('to'), preview_id = $(this).attr('preview'),
		upload_json = GV.EDITOR.UPLOAD_JSON + ('yes' == $(this).attr('thumb') ? '&thumb=yes' : '');

	var editor_module = KindEditor.editor({
		basePath : GV.EDITOR.BASE_PATH,
		pluginsPath : GV.EDITOR.PLUGIN_PATH,
		langType : GV.LANG_NAME,
		uploadJson : upload_json,
		fileManagerJson :  GV.EDITOR.FILE_MANAGER_JSON,
		extraFileUploadParams : GV.EDITOR.FORM_DATA,
		allowFileManager : true
	});

	editor_module.loadPlugin('image', function() {
		editor_module.plugin.imageDialog({
			imageUrl : KindEditor(to_id).val(),
			clickFn : function(url, title, width, height, border, align) {
				KindEditor(to_id).val(url);
				if(preview_id) {
					KindEditor(preview_id).attr('src', url);
				}
				editor_module.hideDialog();
			}
		});
	});
});

})(jQuery, LOGA);
