/* index */
(function ($, LOGA) {

/* operation map */
$(document).on('click', '#operationMapSwitch', function() {
	$.FEA.dialog({
		title: LOGA.L('OPERATION_MAP'),
		content: document.getElementById('operationMap'),
		padding: '6px 3px',
		id: 'OM'
	}).showModal();
})
.on('click', '#operationMap li a', function(e) {
	$.FEA.dialog({id:'OM'}).close();
});

/* lock screen */
$(document).on('click', '#screenLockSwitch', function() {
	$.get(GV.URL.LOCK_SCREEN)
	$('#lockTips').html(LOGA.L('SCREEN_LOCK_TIP'));
	$('#screenLock').slideDown();
})
.on('click', '.check_screenlock', function(e) {
	var lock_password = $('#lockPassword').val();
	if(lock_password == '') {
		$('#lockTips').html('<span class="text-danger">' + LOGA.L('INPUT_NO_EMPTY') + '</span>');
		return false;
	}
	$.getJSON(GV.URL.CHECK_SCREEN_LOCK, {lock_password : lock_password}, function(data) {
		if(1 == data.data) {
			$('#lockTips').html('<span class="text-success">' + data.info + '</span>');
			$('#lockPassword').val('');
			$('#screenLock').slideUp();
		}
		else {
			$('#lockTips').html('<span class="text-danger">' + data.info + '</span>');
		}
	});
	return false;
});


$(document).ready(function() {
	/* forbidden iframe */
	if(top != self) {
		top.location = self.location;
	}
	/* resize #main and .sidebar */
	$('#mainContent').css({height: $(window).height() - 80});
	$(window).resize(function() {
		$('#mainContent').css({height: $(window).height() - 80});
	});
});

/* check new version */
$(document).ready(function() {
	$.getJSON(GV.URL.CHECK_NEW_VERSION, function(result) {
		if(1 == result.data) {
			var newVersion = result.info;
			$('#check_result').html('');
			dialog({
				quickClose: true,
				title: LOGA.L('NEW_VERSION'),
				content: '<a href="' + GV.URL.SOFT_AUTHOR_URL + '" target="_blank">' + LOGA.L('NEW_VERSION') + ': ' + newVersion + '</a>',
				padding: '10px 5px',
				id: 'OM'
			}).showModal();
		}
	});
});

})(jQuery, LOGA);
