/** menu */
(function ($, LOGA) {

$(document).on('submit', '#formAdd, #formEdit', function() {
	if('' == $("select[name='ms_alias']").val()) {
		alert(LOGA.L('CHOOSE_MENU_SPACE'));
		return false;
	}
});

$(document).on('change', '#ms_alias', function() {
	get_menuList($('#ms_alias').val());
});

/* get menu list by space alias */
function get_menuList(ms_alias) {
	$('#m_parent_id').html('');
	if('' != ms_alias) {
		$.getJSON(GV.URL.GET_MENU_LIST, {ms_alias:ms_alias}, function(data) {
			$('#m_parent_id').append('<option value="">' + LOGA.L('TOP_MENU') + '</option>');
			for(key in data.data) {
				if(GV.MENU_ID != data.data[key]['menu_id']) {
					var optionStr = '<option value="' + data.data[key]['menu_id'] + '">' + data.data[key]['m_name'] + '</option>';
					$('#m_parent_id').append(optionStr);
				}
			}
		});
	}
}

$(document).on('change', '.get_actn_list', function() {
	var ctrlr = $(this).val();
	$('#actn').html('');
	$.getJSON(GV.URL.GET_ACTN_LIST, {ctrlr:ctrlr}, function(data) {
		for(key in data.data) {
			var optionStr = '<option value="' + data.data[key]+'">' + data.data[key] + '</option>';
			$('#actn').append(optionStr);
		}
	});
})
.on('click', '.compose_url', function() {
	var groupVal = 'home';
	var ctrlrVal = parse_name($('#ctrlr').val());
	var actnVal = $('#actn').val();
	var paramsVal = $('#params').val();
	if(ctrlrVal && actnVal) {
		if(paramsVal) {
			var val = groupVal+'@'+ctrlrVal+'/'+actnVal+'?'+paramsVal;
		}
		else {
			var val = groupVal+'@'+ctrlrVal+'/'+actnVal;
		}
		$('#m_url').val(val);
	}
	else {
		alert(LOGA.L('CTRLR_OR_ACTN_EMPTY'));
	}
});

/* parse name:AaaBbb -> aaa_bb */
function parse_name(name) {
	name = name.replace(/([A-Z])/g, "_$1").toLowerCase().replace(/(^_)/g, "");
	return name;
}

$(document).on('click', '.build_menu_category', function() {
	$('#compose_btn').trigger('click');
	$('#m_url').val('home@article/show_category?article_category_id=' + $('#article_category_id').val());
	$('#m_name').val($('#article_category_id_category_select').find('[value=' + $('#article_category_id').val() + ']').text()).focus();
})
.on('click', '.build_menu_article', function() {
	$('#compose_btn').trigger('click');
	$('#m_url').val('home@article/show_article?article_id=' + $('#article_id').val());
	$('#m_name').focus();
})
.on('click', '.build_menu_single_page', function() {
	$('#compose_btn').trigger('click');
	$('#m_url').val('home@single_page/show_single_page?single_page_id=' + $('#single_page_id').val());
	$('#m_name').focus();
});

$(document).on('click', '.build_menu', function() {
	var url = $(this).attr('url');
	$('#compose_btn').trigger('click');
	switch(url) {
		case 'index':
			$('#m_url').val('home@index/index');
			$('#m_name').val(LOGA.L('HOME_INDEX')).focus();
			break;
		case 'guestbook_list':
			$('#m_url').val('home@guestbook/list_guestbook');
			$('#m_name').val(LOGA.L('GUESTBOOK_LIST')).focus();
			break;
		default :
			$('#m_url').val(url);
			$('#m_name').focus();
			break;
	}
});

})(jQuery, LOGA);
