/** dashboard */
(function ($, LOGA) {

var option = {
	maxDepth: 1,
	rootClass: 'shortcut_set_root',
	listClass: 'shortcut_set',
	itemClass: 'shortcut_item',
	handleClass: 'shortcut_handle',
	listNodeName: 'tbody',
	itemNodeName: 'tr'
};

/* shortcut manage */
$(document).on('click', '#manage_shortcut', function() {
	$.FEA.dialog({
		title: LOGA.L('MANAGE_SHORTCUT'),
		content: document.getElementById('form_manage_shortcut'),
		id: 'FMS',
		okValue: LOGA.L('OK'),
		ok: function () {
			$('#formManage').submit();
			return false;
		},
		cancelValue: LOGA.L('CANCEL'),
		cancel: function () {}
	}).showModal();

	$('.shortcut_set_root').tree(option);
}).on('change', '.get_actn_list', function() {
	var ctrlr = $(this).val();
	$('#actn').html('');
	$.getJSON(GV.URL.GET_ACTN_LIST, {ctrlr:ctrlr}, function(data) {
		for(key in data.data) {
			var optionStr = '<option value="' + data.data[key]+'">' + data.data[key] + '</option>';
			$('#actn').append(optionStr);
		}
	});
})
.on('click', '.create_shortcut', function() {
	var shortcutStr = '',
		k;
	if(0 == $('#shortcut_set tr.shortcut_item').length) {
		k = 0;
	}
	else {
		k = Number($('#shortcut_set tr:last').attr('k')) + 1;
	}

	var titleVal = $('#shortcut_title').val(),
		aliasVal = $('#shortcut_alias').val(),
		ctrlrVal = parse_name($('#ctrlr').val()),
		actnVal = $('#actn').val();
	if(ctrlrVal && actnVal) {
		var val = 'admin@'+ctrlrVal+'/'+actnVal;
		shortcutStr = '<tr class="shortcut_item" k="'+k+'">';
		shortcutStr += '	<td class="shortcut_handle tree-sortable-handle"><i class="icon-bars"></i></td>';
		shortcutStr += '	<td><input type="text" name="shortcut_set['+k+'][shortcut_title]" value="'+titleVal+'" validate="/\\S+/" class="control-input input-sm" maxlength="96" size="12"></td>';
		shortcutStr += '	<td><input type="text" name="shortcut_set['+k+'][shortcut_alias]" value="'+aliasVal+'" validate="/\\S+/" class="control-input input-sm" maxlength="255" size="20"></td>';
		shortcutStr += '	<td><input type="text" name="shortcut_set['+k+'][shortcut_url]" value="'+val+'" validate="/\\S+/" class="control-input input-sm" maxlength="255" size="40"></td>';
		shortcutStr += '	<td><span class="btn btn-sm delete_shortcut">' + LOGA.L('DELETE') + '</span></td>';
		shortcutStr += '</tr>';
		$('#shortcut_set').append(shortcutStr);
	}
	else {
		alert(LOGA.L('CTRLR_OR_ACTN_EMPTY'));
	}
})
.on('click', '.delete_shortcut', function() {
	$(this).parent().parent().remove();
});

$('.shortcut_set_root').tree(option);

/* parse name:AaaBbb -> aaa_bb */
function parse_name(name) {
	name = name.replace(/([A-Z])/g, "_$1").toLowerCase().replace(/(^_)/g, "");
	return name;
}

})(jQuery, LOGA);
