/**
 * Created by QRYL on 2017/7/6.
 */
function switchMidCenter(url, layout_id) {
    var panel = $('#cv-mid-layout-'+layout_id).layout('panel','center');
    panel.panel('refresh', url);
}

function switchArchiveLayout(url) {
    var panel = $('#cv-mid-layout-archive').layout('panel','center');
    panel.panel('refresh', url);
}

function switchRenderLayout(url) {
    var panel = $('#cv-mid-layout-render').layout('panel','center');
    panel.panel('refresh', url);
}

function switchInnerCenter(tag, url) {
    var panel = $('#'+tag).layout('panel','center');
    panel.panel('refresh', url);
}

function updateViewCache(url) {
    $.ajax({
        url:url,
        type: 'POST',
        dataType:'json',
        success: function (response) {
            message(response.message);
        }
    })
}

function openDialog(title, url, width, height, full) {
    var dialog = layer.open({
        type: 2,
        title: title,
        content: url,
        area: [width, height],
        anim: 5,
        shade: [0.1, '#999']
    });
    if (full) {
        layer.full(dialog);
    }
}

function openDialogNoTitle(url, width, height, full) {
    var dialog = layer.open({
        type: 2,
        content: url,
        area: [width, height],
        anim: 2,
        shade: [0.1, '#666'],
        title: false,
        // closeBtn:0
    });
    if (full) {
        layer.full(dialog);
    }
}

function archiveWindow(url,width,height) {
    var cArchive = $('#cv-mid-layout-archive');
    var cWidth = parseInt(cArchive.css('width'));
    var cHeight = cArchive.css('height');
    var dialog = layer.open({
        type: 2,
        content: url,
        area: [cWidth-201+'px',cHeight],
        offset: 'rb',
        anim: 2,
        shade: [0.1, '#fff'],
        title: false,
        skin: 'cv_layer_noshadow',
        closeBtn:0
    });
}

function message(content) {
    layer.msg(content, {time: 800, offset: 't'});
}

var bodyHeight = window.document.body.clientHeight;
var bodyWidth = window.document.body.clientWidth;