<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: DistributeController.php
 * Time: 15:38
 */

namespace app\app\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CommonKit;
use Symfony\Component\Filesystem\Filesystem;

class DistributeController extends BaseController
{
    public function redirectAction()
    {
        $siteId = intval(input('?get.site_id') ? input('get.site_id') : input('post.site_id', 1));
        $categoryId = intval(input('?get.category_id') ? input('get.category_id') : input('post.category_id', 0));
        if ($categoryId === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $cat = CommonKit::getCategoryByCategoryId($categoryId);
        $this->redirect(request()->domain() . $cat['url'], 302);
    }

    public function riAction()
    {
        $filesystem = new Filesystem();
        $assetsPath = ROOT_PATH . 'resources' . DS . 'asset' . DS . 'install';
        $modulePath = APP_PATH . 'install';
        $filesystem->remove([$assetsPath, $modulePath]);
        $this->redirect(request()->domain() . request()->root());
    }
}