<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: BaseController.php
 * Time: 7:55
 */

namespace app\common\controller;


use app\common\toolKit\SiteKit;
use covercms\bridge\twig\CoverTwigExtension;
use think\Controller;

class BaseController extends Controller
{
    protected function render($tag='', array $context = array(), $viewFile = '')
    {
        $siteInfo = SiteKit::currentSiteInfo();
        $theme = $siteInfo['theme'];
        $baseViewPath = ROOT_PATH . 'resources' . DS . 'views' . DS . $theme;
        $action = request()->action();
        $finalViewFile = $tag . '_' . $action;
        if (!empty(trim($viewFile))) {
            $finalViewFile .= '_' . strtolower(trim($viewFile));
        }
        if (strtolower(trim($tag)) == 'index' || strtolower(trim($tag))=='single' || strtolower(trim($tag)) == 'search') {
            $finalViewFile = strtolower(trim($tag));
        }
        if (request()->isMobile() && file_exists($baseViewPath.DS.$finalViewFile.'_m.html.twig')){
            $finalViewFile .= '_m';
        }
        $name = $finalViewFile . '.html.twig';
        $loader = new \Twig_Loader_Filesystem($baseViewPath);
        $twig = new \Twig_Environment($loader, [
            'cache' => RUNTIME_PATH . 'twig',
            'auto_reload' => true
        ]);
        $twig->addExtension(new CoverTwigExtension());
        $view = $twig->render($name, $context);
        return '<!--

@author: CoverPrise.DevTeam

Copyright (c) 2017 CoverPrise/Nulang Technology.

-->
'.$view;
    }

    protected function getUser()
    {
        $manager = [];
        if (session('?manager')) {
            $manager = unserialize(session('manager'));
        }
        if (count($manager)>0){
            $manager['nick_name'] = $manager['true_name'];
        }
        return $manager;
    }
}