<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: CommonKit.php
 * Time: 13:54
 */

namespace app\common\toolKit;


use think\Db;

class CommonKit
{
    public static function isMissing(array $items, array $target, $checkEmpty = true)
    {
        $status = false;
        foreach ($items as $item) {
            if (array_key_exists($item, $target)) {
                if ($checkEmpty) {
                    if (is_string($target[$item])) {
                        if (empty($target[$item])) {
                            $status = true;
                            break;
                        }
                    } elseif (is_array($target[$item])) {
                        if (count($target[$item]) < 1) {
                            $status = true;
                            break;
                        }
                    }
                }
            } else {
                $status = true;
                break;
            }
        }
        return $status;
    }

    public static function simplyPager(array $data, $page, $perPage = 10)
    {
        if (intval($page) === 0 || intval($perPage) === 0) {
            return [];
        }
        return array_slice($data, (intval($page) - 1) * $perPage, $perPage);
    }

    public static function makeOnlineAt($value)
    {
        $result = time();
        $onlineAt = strtotime($value);
        if ($onlineAt && $onlineAt <= 2145758400) {
            $result = $onlineAt;
        }
        return $result;
    }

    public static function makeDownAt($value)
    {
        $result = 2145758400;
        $downAt = strtotime($value);
        if ($downAt && $downAt <= 2145758400) {
            $result = $downAt;
        }
        return $result;
    }

    public static function getModelByCType($cType,$chinese=false)
    {
        $arr = [
            1 => 'article',
            2 => 'product',
            3 => 'single',
            4 => 'case',
            5 => 'hr',
            0 => 'link'
        ];
        if ($chinese){
            $arr = [
                1 => '文章',
                2 => '产品',
                3 => '单页',
                4 => '案例',
                5 => 'hr',
                0 => '外部链接'
            ];
        }
        if (array_key_exists($cType, $arr)) {
            return $arr[$cType];
        } else {
            return '';
        }
    }

    public static function getModelByCategoryId($categoryId)
    {
        $categoryId = intval($categoryId);
        $siteId = SiteKit::currentSiteId();
        if (!cache('?categories.site.' . $siteId)) {
            return '';
        }
        $categories = cache('categories.site.' . $siteId);
        if (!array_key_exists($categoryId, $categories)) {
            return '';
        }
        $cType = $categories[$categoryId]['c_type'];
        return self::getModelByCType($cType);
    }

    public static function getCategoryByCategoryId($categoryId)
    {
        $result = [];
        $cid = intval($categoryId);
        if (!cache('categories.site.'.SiteKit::currentSiteId())){
            return [];
        }
        $categoriesFromCache = cache('categories.site.'.SiteKit::currentSiteId());
        if (array_key_exists($cid,$categoriesFromCache)){
            $result = $categoriesFromCache[$cid];
            $cType  = intval($result['c_type']);
            $cType = CommonKit::getModelByCType($cType);
            if ($cType=='single'){
                $catId = $result['id'];
                if ($result['has_children']) {
                    $maxWeightSonId = self::findMaxWeightSonId(intval($result['id']));
                    $catId = $maxWeightSonId;
                }
                $result['url'] = url('app/default/single',['cid'=>$catId]);
            }elseif ($cType=='link'){
            }else{
                if ($result['has_children']){
                    $result['url'] = url('app/default/channel',['cid'=>$result['id']]);
                }else{
                    $result['url'] = url('app/default/list',['cid'=>$result['id']]);
                }
            }
        }
        return $result;
    }

    private static function findMaxWeightSonId($parentId)
    {
        $directSons = Db::name('category')->field('id,weight')->order('weight desc')->where('parent_id', intval($parentId))->select();
        return $directSons[0]['id'];
    }

    public static function request($url, $data, $headers)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // post数据
        curl_setopt($ch, CURLOPT_POST, 1);
        // post的变量
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $output = curl_exec($ch);
        curl_close($ch);
        return json_decode($output, true);
    }
}