<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: FormKit.php
 * Time: 8:56
 */

namespace app\common\toolKit;


use think\Db;

class FormKit
{
    private static $status='get';
    
    private static $originData;

    public static function get()
    {
        self::$status = 'get';
        $fields = Db::name('product_attr')->select();
        $result = [];
        if (count($fields)>0){
            foreach ($fields as $field){
                $fieldType = $field['field_type'];
                if (method_exists(new static(), $fieldType)){
                    $row = self::$fieldType($field);
                    array_push($result, $row);
                }
            }
        }
        return $result;
    }

    public static function input($data)
    {
        self::$status = 'input';
        self::$originData = $data;
        foreach ($data as $k=>$datum){
            $fieldType = self::findFieldType($k);
            if (method_exists(new static(), $fieldType)){
                self::$fieldType($k);
            }
        }
        return json_encode(self::$originData);
    }
    
    public static function output($data)
    {
        self::$status = 'output';
        $result = [];
        if (count($data)>0){
            self::$originData = json_decode($data, true);
            foreach (self::$originData as $k=>$datum){
                $field = self::findFieldType($k, true);
                $fieldType = $field['field_type'];
                if (method_exists(new static(), $fieldType)){
                    $field['value'] = $datum;
                    $row = self::$fieldType($field);
                    array_push($result, $row);
                }
            }
        }
        return $result;
    }

    private static function findFieldType($field,$full=false)
    {
        $item = Db::name('product_attr')->where('field', $field)->find();
        if (!$item){
            return false;
        }
        if ($full){
            return $item;
        }
        return $item['field_type'];
    }

    public static function image($field)
    {
        if (self::$status=='input' || isset($field['form_block_input'])){

        }else{
            $parent = 'parent.';
            $isOwn = 'false';
            if (isset($field['from_block']) && $field['from_block']){
                $parent = '';
                $isOwn = 'true';
            }
            if (!isset($field['value']) || empty(trim($field['value'])) || is_null($field['value'])){
                $field['value'] = '';
            }
            $str = '<div class="cv-input-box">';
            $str.=self::label($field['label']);
            $str.='<div class="controls"><input value="'.$field['value'].'" class="cv-input-xlarge" type="text" id="cv_extra_'.$field['field'].'" name="cv[extra]['.$field['field'].']" /></div>';
            $str.='<div class="append"><button onclick="upload_cv_extra_'.$field['field'].'();" type="button" class="cv-button cv-button-primary">选取</button></div>';
            $str.='<script type="text/javascript">
        function upload_cv_extra_'.$field['field'].'() {
            '.$parent.'openDialog("媒体上传","'.url('dash/media/new',['cl'=>'returnImageUrlToParent(\'cv_extra_'.$field['field'].'\',response.f_url,'.$isOwn.');|closeSelf();']).'",\'750px\',\'520px\');
        }
    </script>';
            return $str;
        }
    }

    public static function image_group($field)
    {
        if (self::$status=='input' || isset($field['form_block_input'])){
            $originData = self::$originData;
            $selfData = $originData[$field];
            $groupResult = [];
            if (count($selfData)>0){
                foreach ($selfData as $datum){
                    if (!empty(trim($datum['img']))){
                        array_push($groupResult, $datum);
                    }
                }
            }
            self::$originData[$field] = $groupResult;
        }else{
            $parent = 'parent.';
            $isOwn = 'false';
            if (isset($field['from_block']) && $field['from_block']){
                $parent = '';
                $isOwn = 'true';
            }
            $str = '';
            if (!defined('COVER_IMAGE_GROUP_INIT')){
                define('COVER_IMAGE_GROUP_INIT', true);
                $str.='<link type="text/css" rel="stylesheet" href="'.asset('dash/libs/dragula/dragula.min.css').'" />';
                $str.='<script type="text/javascript" src="'.asset('dash/libs/dragula/dragula.min.js').'"></script>';
            }
            $str .= '<div class="cv-single-title cv-clear" style="border:0;border-bottom:1px solid #e6e6e6;background-color: transparent;">图片组</div>';

            $start = 2;
            if (isset($field['value']) && !empty($field['value']) && !is_null($field['value'])){
                if (self::$status=='output'){
                    $valueArr = $field['value'];
                }else{
                    $valueArr = json_decode($field['value'], true);
                }
                $start = count($valueArr)+1;
                $str .='<div id="cv_extra_'.$field['field'].'_box">';
                foreach ($valueArr as $key=>$item){
                    $key = $key+1;
                    $str .= '<div style="clear: both;height:100px;padding-left:15px;padding-top:15px;;border-bottom: 1px dotted #ddd;" id="cv_extra_'.$field['field'].'_box_add_'.$key.'"><div style="float: left;">
            <input type="hidden" value="'.$item['img'].'" name="cv[extra]['.$field['field'].'][box'.$key.'][img]" id="cv_extra_'.$field['field'].'_box'.$key.'_img" /><img id="cv_extra_'.$field['field'].'_box'.$key.'_img_preview" style="width: 80px;height: 60px;" class="cv-cursor" onclick="upload_cv_extra_'.$field['field'].'(this)" src="'.$item['img'].'" />
            </div><div style="float: left;padding-top: 5px;"><div class="cv-input-box"><label>描述</label><div class="controls"><textarea class="cv-input-xlarge" name="cv[extra]['.$field['field'].'][box'.$key.'][description]">'.$item['description'].'</textarea></div>
            </div><div class="cv-input-box"><label>链接</label><div class="controls"><input value="'.$item['url'].'" type="text" class="cv-input-xlarge" name="cv[extra]['.$field['field'].'][box'.$key.'][url]" /></div>
            </div></div><div style="float: right;margin-right: 20px;padding-top: 10px;"><img class="cv-cursor" onclick="add_cv_extra_'.$field['field'].'_node('.$key.')" src="'.asset('dash/img/icon403a20.png').'">
            <img class="cv-cursor" style="margin-left: 5px;" onclick="remove_cv_extra_'.$field['field'].'_node('.$key.')" src="'.asset('dash/img/icon403a19.png').'"></div></div>';
                }
                $str.='</div>';

            }else{
                $str .= '<div id="cv_extra_'.$field['field'].'_box"><div style="clear: both;height:100px;padding-left:15px;padding-top:15px;;border-bottom: 1px dotted #ddd;" id="cv_extra_'.$field['field'].'_box_add_1"><div style="float: left;">
            <input type="hidden" name="cv[extra]['.$field['field'].'][box1][img]" id="cv_extra_'.$field['field'].'_box1_img" /><img id="cv_extra_'.$field['field'].'_box1_img_preview" style="width: 80px;height: 60px;" class="cv-cursor" onclick="upload_cv_extra_'.$field['field'].'(this)" src="'.asset('dash/img/addpicture.png').'" />
            </div><div style="float: left;padding-top: 5px;"><div class="cv-input-box"><label>描述</label><div class="controls"><textarea class="cv-input-xlarge" name="cv[extra]['.$field['field'].'][box1][description]"></textarea></div>
            </div><div class="cv-input-box"><label>链接</label><div class="controls"><input type="text" class="cv-input-xlarge" name="cv[extra]['.$field['field'].'][box1][url]" /></div>
            </div></div><div style="float: right;margin-right: 20px;padding-top: 10px;"><img class="cv-cursor" onclick="add_cv_extra_'.$field['field'].'_node(1)" src="'.asset('dash/img/icon403a20.png').'">
            <img class="cv-cursor" style="margin-left: 5px;" onclick="remove_cv_extra_'.$field['field'].'_node(1)" src="'.asset('dash/img/icon403a19.png').'"></div></div></div>';
            }
            $str.='<script type="text/javascript">
        $(function () {
            dragula([document.getElementById(\'cv_extra_'.$field['field'].'_box\')]);
        });
        var plus = \''.asset('dash/img/icon403a20.png').'\';
        var reduce = \''.asset('dash/img/icon403a19.png').'\';
          var cv_extra_'.$field['field'].'_node = '.$start.';
        function upload_cv_extra_'.$field['field'].'(o) {
            var preview = o.id;
            var input = preview.replace(\'_preview\',\'\');
            var url = \''.url('dash/media/new').'\'+ "?cl=returnImageToParent(\'"+input+"\',response.f_url,'.$isOwn.');|closeSelf();";
            '.$parent.'openDialog("媒体上传",url,\'750px\',\'520px\');
        }
        function remove_cv_extra_'.$field['field'].'_node(position) {
            var allOption = $("[id^=\'cv_extra_'.$field['field'].'_box_add_\']").length;
            if(allOption>1){
                $(\'#cv_extra_'.$field['field'].'_box_add_\'+position).remove();
            }else {
                '.$parent.'message(\'请至少保留一项\');
            }
        }
        function add_cv_extra_'.$field['field'].'_node(position) {
           var node = cv_extra_'.$field['field'].'_node;
        var a = \'<div style="clear: both;height: 100px;padding-left:15px;padding-top:15px;border-bottom: 1px dotted #ddd;" id="cv_extra_'.$field['field'].'_box_add_\'+node+\'">\'+
            \'<div style="float: left;"><input type="hidden" name="cv[extra]['.$field['field'].'][box\'+node+\'][img]" id="cv_extra_'.$field['field'].'_box\'+node+\'_img" /><img id="cv_extra_'.$field['field'].'_box\'+node+\'_img_preview"  style="width: 80px;height: 60px;" class="cv-cursor" onclick="upload_cv_extra_'.$field['field'].'(this)" src="'.asset('dash/img/addpicture.png').'" /></div><div style="float: left;padding-top:5px;"><div class="cv-input-box"><label>描述</label>\'+
            \'<div class="controls"><textarea class="cv-input-xlarge" name="cv[extra]['.$field['field'].'][box\'+node+\'][description]"></textarea></div></div><div class="cv-input-box"><label>链接</label>\'+
            \'<div class="controls"><input type="text" class="cv-input-xlarge" name="cv[extra]['.$field['field'].'][box\'+node+\'][url]" /></div></div></div>\'+
            \'<div style="float: right;margin-right: 20px;padding-top: 10px;">\'+
            \'<img class="cv-cursor" onclick="add_cv_extra_'.$field['field'].'_node(\'+node+\');" src="\'+plus+\'">\'+
        \'<img class="cv-cursor" style="margin-left: 5px;" onclick="remove_cv_extra_'.$field['field'].'_node(\'+node+\');" src="\'+reduce+\'">\'+
        \'</div></div>\';
        $(\'#cv_extra_'.$field['field'].'_box_add_\'+position).after(a);
        cv_extra_'.$field['field'].'_node++;
    }
    </script>';
            return $str;
        }
    }

    public static function video($field)
    {
        if (self::$status=='input' || isset($field['form_block_input'])){
            $originData = self::$originData;
            $selfData = $originData[$field];
            $pathinfo = pathinfo($selfData);
            if ($pathinfo['extension']!='mp4'){
                self::$originData[$field] = '';
            }
        }else{
            if (!isset($field['value']) || empty(trim($field['value'])) || is_null($field['value'])){
                $field['value'] = '';
            }
            $str = '<div class="cv-input-box">';
            $str.=self::label($field['label']);
            $str.='<div class="controls"><input value="'.$field['value'].'" class="cv-input-xlarge"  id="cv_extra_'.$field['field'].'" type="text" name="cv[extra]['.$field['field'].']" /></div>';
            $str.='</div>';
            return $str;
        }
    }

    public static function single_text($field)
    {
        if (self::$status=='input' || isset($field['form_block_input'])){

        }else{
            if (!isset($field['value']) || empty(trim($field['value'])) || is_null($field['value'])){
                $field['value'] = '';
            }
            $str = '<div class="cv-input-box">';
            $str.= self::label($field['label']);
            $str.='<div class="controls"><input value="'.$field['value'].'" class="cv-input-xlarge" id="cv_extra_'.$field['field'].'" type="text" name="cv[extra]['.$field['field'].']" /></div>';
            $str.='</div>';
            return $str;
        }
    }

    public static function multi_text($field)
    {
        if (self::$status=='input' || isset($field['form_block_input'])){

        }else{
            if (!isset($field['value']) || empty(trim($field['value'])) || is_null($field['value'])){
                $field['value'] = '';
            }
            $str = '<div class="cv-input-box">';
            $str.= self::label($field['label']);
            $str.='<div class="controls"><textarea class="cv-input-xlarge" id="cv_extra_'.$field['field'].'" name="cv[extra]['.$field['field'].']">'.$field['value'].'</textarea></div>';
            $str.='</div>';
            return $str;
        }
    }

    private static function rich_text($field)
    {
        if (self::$status=='input'){

        }else{
            $str = '';
            if(!defined('COVER_EDITOR_INIT')) {
                $str = '<script type="text/javascript" src="'.asset('share/libs/ckeditor/ckeditor.js').'"></script>';
                define('COVER_EDITOR_INIT', 1);
            }
            if (!isset($field['value']) || empty(trim($field['value'])) || is_null($field['value'])){
                $field['value'] = '';
            }
            $str.='<div class="cv-input-box"><textarea id="cv_'.$field['field'].'" name="cv['.$field['field'].']">'.$field['value'].'</textarea></div>';
            $str.="<script type='text/javascript'>\r\n";
            $str.='CKEDITOR.replace("cv_'.$field['field'].'")';
            $str .= "</script>";
            return $str;
        }
    }

    private static function label($label)
    {
        return '<label>'.$label.'</label>';
    }
}