<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: ArchiveController.php
 * Time: 22:51
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CommonKit;
use app\common\toolKit\SiteKit;

class ArchiveController extends BaseController
{
    private $categoryId;

    private $siteId;

    public function _initialize()
    {
        $categoryId = input('?get.category_id') ? intval(input('get.category_id')) : input('post.category_id',0);
        if (intval($categoryId)===0){
            return json(['success'=>false, 'message'=>lang('Failure')]);
        }
        $this->categoryId = intval($categoryId);
        $this->siteId = SiteKit::currentSiteId();
    }

    public function indexAction()
    {
        if (request()->isPost()) {
            return json(['total' => 0, 'rows' => []]);
        }
        $this->assign(['category_id' => $this->categoryId]);
        return $this->fetch();
    }

    public function newAction()
    {
        $categories = $this->categories();
        $categoryCType = $categories[$this->categoryId]['c_type'];
        $cType = CommonKit::getModelByCType($categoryCType);
        $action = $cType.'NewAction';
        self::$action();
    }

    public function articleNewAction()
    {
        if (request()->isPost()) {
            return json(['success'=>true, 'message'=>lang('Success')]);
        }
        return $this->fetch('article');
    }

    private function categories()
    {
        return cache('categories.site.'.$this->siteId);
    }
}