<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: ArticleController.php
 * Time: 9:38
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CommonKit;
use app\common\toolKit\SiteKit;
use think\Db;
use think\Hook;

class ArticleController extends BaseController
{
    private $categoryId;

    private $siteId;

    private $articleDb;

    public function _initialize()
    {
        $categoryId = input('?get.category_id') ? intval(input('get.category_id')) : input('post.category_id', 0);
        if (intval($categoryId) === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $this->categoryId = intval($categoryId);
        $this->siteId = SiteKit::currentSiteId();
//        $this->articleDb = Db::name('article');
    }

    public function indexAction()
    {
        if (request()->isPost()) {
            $total = Db::name('article')->where('category_id', $this->categoryId)->count();
            $endRows = [];
            if ($total > 0) {
                if (!input('?post.page') || !input('?post.rows')) {
                    return json(['success' => false, 'message' => lang('Failure')]);
                }
                $page = input('post.page');
                $listRows = input('post.rows');
                $rows = Db::name('article')->where('category_id', $this->categoryId)->page($page, $listRows)->order('weight desc')->select();
                foreach ($rows as $row) {
                    $node['id'] = $row['id'];
                    $node['create_time'] = date('Y-m-d H:i:s', $row['create_time']);
                    $node['update_time'] = date('Y-m-d H:i:s', $row['update_time']);
                    $content = '<h6>' . $row['title'];
                    if ($row['recom']){
                        $content.= '&nbsp;&nbsp;<span style="color:red;">[推荐]</span>';
                    }
                    if ($row['top']){
                        $content.='&nbsp;&nbsp;<span style="color:orange;">[置顶]</span>';
                    }
                    $content .= '</h6>';
                    $node['title'] = $content;
                    $editUrl = url('edit', ['category_id' => $this->categoryId, 'id' => $row['id']]);
                    $deleteUrl = url('delete', ['category_id' => $this->categoryId, 'id' => $row['id']]);
                    $node['actions'] = '<a class="cv-btn primary" href="javascript:archiveWindow(\'' . $editUrl . '\',' . '\'520px\',' . '\'330px\'' . ')">编辑</a>' . '&nbsp;&nbsp;' .
                        '<a class="cv-btn red" href="javascript:deleteArticleData(\'' . $deleteUrl . '\')">删除</a>';
                    $node['order'] = '<input style="width:35px;" type="text" name="cv[article][' . $row['id'] . ']" value="' . $row['weight'] . '" />';
                    array_push($endRows, $node);
                }
            }
            return json(['total' => $total, 'rows' => $endRows]);
        }
        $this->assign(['category_id' => $this->categoryId]);
        return $this->fetch();
    }

    public function newAction()
    {
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['title', 'full_text'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            $dataFromPost['category_id'] = $this->categoryId;
            if (empty(trim($dataFromPost['author']))) {
                $user = $this->getUser();
                $dataFromPost['author'] = (isset($user['nick_name']) && !empty($user['nick_name'])) ? trim($user['nick_name']) : $user['username'];
            }
            $dataFromPost['create_time'] = $dataFromPost['update_time'] = time();
            $lastInsertedItem = Db::name('article')->insertGetId($dataFromPost);
            if (!$lastInsertedItem) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            Db::name('article')->where('id', $lastInsertedItem)->update(['weight' => $lastInsertedItem]);
            $listenerParams = ['category_id' => $this->categoryId, 'action' => 'add'];
            Hook::listen('category_items', $listenerParams);
            return json(['success' => true, 'message' => lang('Success')]);
        }
        return $this->fetch();
    }

    public function editAction()
    {
        $id = intval(input('?get.id') ? input('get.id') : input('post.id', 0));
        if ($id === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['title', 'full_text'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            $dataFromPost['update_time'] = time();
            if (empty(trim($dataFromPost['author']))) {
                $user = $this->getUser();
                $dataFromPost['author'] = (isset($user['nick_name']) && !empty($user['nick_name'])) ? trim($user['nick_name']) : $user['username'];
            }
            Db::name('article')->where('id', $id)->update($dataFromPost);
            return json(['success' => true, 'message' => lang('Success')]);
        }
        $item = Db::name('article')->where('id', $id)->find();
        if (!$item) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $this->assign([
            'item' => $item
        ]);
        return $this->fetch();
    }

    public function deleteAction()
    {
        $id = intval(input('?get.id') ? input('get.id') : input('post.id', 0));
        if ($id === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $rst = Db::name('article')->where('id', $id)->delete();
        if (!$rst) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $listenerParams = ['category_id' => $this->categoryId, 'action' => 'remove'];
        Hook::listen('category_items', $listenerParams);
        return json(['success' => true, 'message' => lang('Success')]);
    }

    public function deleteAllAction()
    {
        if (request()->isPost()) {
            if ($needDeleteRows = input('post.rows/a')) {
                if (is_array($needDeleteRows) && count($needDeleteRows) > 0) {
                    $rst = Db::name('article')->delete($needDeleteRows);
                    if (!$rst) {
                        return json(['success' => false, 'message' => lang('Failure')]);
                    }
                    $listenerParams = ['category_id' => $this->categoryId, 'action' => 'remove', 'num' => count($needDeleteRows)];
                    Hook::listen('category_items', $listenerParams);
                    return json(['success' => true, 'message' => lang('Success')]);
                }
            }
        }
    }

    public function orderAction()
    {
        $dataFromPost = request()->post('cv/a', null);
        $needOrders = $dataFromPost['article'];
        foreach ($needOrders as $key => $value) {
            Db::name('article')->where('id', $key)->update(['weight' => $value]);
        }
        return json(['success' => true, 'message' => lang('Success')]);
    }
}