<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: BlockController.php
 * Time: 15:35
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CommonKit;
use app\common\toolKit\FormKit;
use think\Db;

class BlockController extends BaseController
{
    public function indexAction()
    {
        if (request()->isPost()) {
            $items = Db::name('block')->order('weight desc')->select();
            $total = 0;
            $itemsTotal = count($items);
            if ($itemsTotal > 0) {
                $total = $itemsTotal;
                $fieldType = [
                    'image' => '图片',
                    'image_group' => '图片组',
                    'video' => '视频',
                    'single_text' => '单行文本',
                    'multi_text'=>'多行文本'
                ];
                foreach ($items as &$item) {
                    $editUrl = url('edit', ['id' => $item['id']]);
                    $deleteUrl = url('delete', ['id' => $item['id']]);
                    $item['actions'] = '';
//                    $item['actions'] .= '<a class="cv-btn primary" href="javascript:openDialog(' . '\'编辑内容标签\',' . '\'' . $editUrl . '\',' . '\'520px\',' . '\'330px\'' . ')">编辑</a>';
                    $item['actions'] .= '&nbsp;&nbsp;' .
                        '<a class="cv-btn red" href="javascript:deleteBlockData(\'' . $deleteUrl . '\')">删除</a>';
                    $item['order'] = '<input style="width:35px;" type="text" name="cv[block][' . $item['id'] . ']" value="' . $item['weight'] . '" />';
                    $item['field_type'] = $fieldType[$item['field_type']];
                }
            }
            return json(['total' => $total, 'rows' => array_values($items)]);
        }
        return $this->fetch();
    }

    public function newAction()
    {
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['title', 'tag', 'field_type'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            $lastInsertedItem = Db::name('block')->insertGetId($dataFromPost);
            if (!$lastInsertedItem) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            return json(['success' => true, 'message' => lang('Success')]);
        }
        return $this->fetch();
    }

    public function editAction()
    {
        $blockId = intval(input('?get.block_id') ? input('get.block_id') : input('post.block_id', 0));
        $item = Db::name('block')->where('id', $blockId)->find();
        $var = 'var';
        if (!$item) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $fieldType = $item['field_type'];
        if (request()->isPost()) {
            $dataFromPost = $_POST['cv']['extra'][$var];
            $result  = $this->$fieldType($dataFromPost);
            Db::name('block')->where('id',$blockId)->update(['var'=>$result]);
            return json(['success' => true, 'message' => lang('Success')]);
        }
        $extra = FormKit::$fieldType(['field' => $var, 'from_block' => true, 'label' => '值', 'value' => $item['var']]);
        $this->assign([
            'block_id' => $blockId,
            'extra' => $extra
        ]);
        return $this->fetch();
    }

    private function image_group($data)
    {
        $selfData = $data;
        $groupResult = [];
        if (count($selfData)>0){
            foreach ($selfData as $datum){
                if (!empty(trim($datum['img']))){
                    array_push($groupResult, $datum);
                }
            }
        }
        return json_encode($groupResult);
    }

    private function single_text($data)
    {
        return $data;
    }

    private function multi_text($data)
    {
        return $data;
    }

    private function image($data)
    {
        return $data;
    }

    private function video($data)
    {
        return $data;
    }
}