<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: DefaultController.php
 * Time: 7:54
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\MenuKit;
use app\common\toolKit\SiteKit;

class DefaultController extends BaseController
{
    public function indexAction()
    {
        $menus = MenuKit::get();
        $sites = cache('sites');
        $siteId = SiteKit::currentSiteId();
        $currentSite = $sites[$siteId];
        $this->assign([
            'menus'=>$menus,
            'current_site'=>$currentSite,
            'user'=>$this->getUser()
        ]);
        return $this->fetch();
    }

    public function sideMenuAction()
    {
        $parentId = input('get.m',0);
        $menus = MenuKit::get(intval($parentId));
        $this->assign([
            'menus'=>$menus,
            'm_id'=>$parentId
        ]);
        return $this->fetch();
    }

    public function archiveAction()
    {
        $siteId = SiteKit::currentSiteId();
        $categories = cache('categories.tree.site.' . $siteId);
        $this->assign([
            'items' => json_encode(array_values($categories))
        ]);
        return $this->fetch();
    }
    
    public function mainAction()
    {
        return $this->fetch();
    }
}