<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: FriendController.php
 * Time: 11:19
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CommonKit;
use app\common\toolKit\SiteKit;
use think\Db;

/**
 * Class FriendController
 * @package app\dash\controller
 */
class FriendController extends BaseController
{
    private $siteId;

    public function _initialize()
    {
        $this->siteId = SiteKit::currentSiteId();
    }

    public function indexAction()
    {
        if (request()->isPost()) {
            $items = Db::name('friend')->where('site_id', $this->siteId)->order('weight desc')->select();
            $total = count($items);
            if ($total > 0) {
                foreach ($items as &$item) {
                    if (empty($item['cover']) || is_null($item['cover'])) {
                        $item['cover'] = asset('share/img/nopicture.png');
                    }
                    $item['cover'] = '<img style="max-width:100%;height:40px;" src="' . $item['cover'] . '" />';
                    $editUrl = url('edit', ['id' => $item['id']]);
                    $deleteUrl = url('delete', ['id' => $item['id']]);
                    $item['actions'] = '<a class="cv-btn primary" href="javascript:openDialog(' . '\'编辑友情链接\',' . '\'' . $editUrl . '\',' . '\'520px\',' . '\'330px\'' . ')">编辑</a>' . '&nbsp;&nbsp;' .
                        '<a class="cv-btn red" href="javascript:deleteFriendData(\'' . $deleteUrl . '\')">删除</a>';
                    $item['order'] = '<input style="width:35px;" type="text" name="cv[friend][' . $item['id'] . ']" value="' . $item['weight'] . '" />';
                }
            }
            return json(['total' => $total, 'rows' => $items]);
        }
        return $this->fetch();
    }

    public function newAction()
    {
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['title'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            $dataFromPost['site_id'] = $this->siteId;
            $lastInsertedItem = Db::name('friend')->insertGetId($dataFromPost);
            if (!$lastInsertedItem) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            Db::name('friend')->where('id', $lastInsertedItem)->update(['weight' => $lastInsertedItem]);
            return json(['success' => true, 'message' => lang('Success')]);
        }
        return $this->fetch();
    }

    public function editAction()
    {
        $id = intval(input('?get.id') ? input('get.id') : input('post.id', 0));
        if ($id === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['title'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            Db::name('friend')->where('id', $id)->update(['title' => $dataFromPost['title'], 'url' => $dataFromPost['url'], 'cover' => $dataFromPost['cover']]);
            return json(['success' => true, 'message' => lang('Success')]);
        }
        $item = Db::name('friend')->where('id', $id)->find();
        if (!$item) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $this->assign('item', $item);
        return $this->fetch();
    }

    public function deleteAction()
    {
        $id = intval(input('?get.id') ? input('get.id') : input('post.id', 0));
        if ($id === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        Db::name('friend')->where('id', $id)->delete();
        return json(['success' => true, 'message' => lang('Success')]);
    }

    public function deleteAllAction()
    {
        if (request()->isPost()) {
            if ($needDeleteRows = input('post.rows/a')) {
                if (is_array($needDeleteRows) && count($needDeleteRows) > 0) {
                    Db::name('friend')->delete($needDeleteRows);
                    return json(['success' => true, 'message' => lang('Success')]);
                }
            }
        }
    }

    public function orderAction()
    {
        $dataFromPost = request()->post('cv/a', null);
        $needOrders = $dataFromPost['friend'];
        foreach ($needOrders as $key=>$value){
            Db::name('friend')->where('id', $key)->update(['weight'=>abs(intval($value))]);
        }
        return json(['success'=>true, 'message'=>lang('Success')]);
    }
}