<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: KefuController.php
 * Time: 16:58
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CacheKit;
use app\common\toolKit\CommonKit;
use think\Db;

class KefuController extends BaseController
{
    private $kfType;

    public function _initialize()
    {
        $kfType = [
            1 => 'QQ客服',
            2 => '阿里旺旺',
            3 => '联系电话'
        ];
        $this->kfType = $kfType;
    }

    public function indexAction()
    {
        if (request()->isPost()) {
            if (!cache('?kfs')) {
                CacheKit::updateKfCache();
            }
            $items = cache('kfs');
            $total = 0;
            if ($items) {
                $total = count($items);
                foreach ($items as &$item) {
                    $item['kf_type'] = $this->kfType[$item['kf_type']];
                    $editUrl = url('edit', ['id' => $item['id']]);
                    $deleteUrl = url('delete', ['id' => $item['id']]);
                    $item['actions'] = '<a class="cv-btn primary" href="javascript:openDialog(' . '\'编辑客服\',' . '\'' . $editUrl . '\',' . '\'520px\',' . '\'330px\'' . ')">编辑</a>' . '&nbsp;&nbsp;' .
                        '<a class="cv-btn red" href="javascript:deleteKefuData(\'' . $deleteUrl . '\')">删除</a>';
                    $item['order'] = '<input style="width:35px;" type="text" name="cv[kefu][' . $item['id'] . ']" value="' . $item['weight'] . '" />';
                }
            }
            return json(['total' => $total, 'rows' => array_values($items)]);
        }
        return $this->fetch();
    }

    public function newAction()
    {
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['account', 'kf_type'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            $lastInsertedItem = Db::name('kefu')->insertGetId($dataFromPost);
            if (!$lastInsertedItem) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            CacheKit::updateKfCache();
            return json(['success' => true, 'message' => lang('Success')]);
        }
        $this->assign([
            'kf_types' => $this->kfType
        ]);
        return $this->fetch();
    }

    public function editAction()
    {
        $id = input('?get.id') ? input('get.id') : input('post.id', 0);
        if (intval($id) === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['account', 'kf_type'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            Db::name('kefu')->where('id', $id)->update($dataFromPost);
            CacheKit::updateKfCache();
            return json(['success' => true, 'message' => lang('Success')]);
        }
        $item = Db::name('kefu')->where('id', $id)->find();
        if (!$item) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $this->assign([
            'item' => $item,
            'kf_types'=>$this->kfType
        ]);
        return $this->fetch();
    }

    public function deleteAction()
    {
        $id = intval(input('?get.id') ? input('get.id') : input('post.id', 0));
        if ($id === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        $rst = Db::name('kefu')->where('id', $id)->delete();
        if (!$rst) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        return json(['success' => true, 'message' => lang('Success')]);
    }

    public function deleteAllAction()
    {
        if (request()->isPost()) {
            if ($needDeleteRows = input('post.rows/a')) {
                if (is_array($needDeleteRows) && count($needDeleteRows) > 0) {
                    $rst = Db::name('kefu')->delete($needDeleteRows);
                    if (!$rst) {
                        return json(['success' => false, 'message' => lang('Failure')]);
                    }
                    return json(['success' => true, 'message' => lang('Success')]);
                }
            }
        }
    }

    public function orderAction()
    {
        $dataFromPost = request()->post('cv/a', null);
        $needOrders = $dataFromPost['kefu'];
        foreach ($needOrders as $key => $value) {
            Db::name('kefu')->where('id', $key)->update(['weight' => abs(intval($value))]);
        }
        return json(['success' => true, 'message' => lang('Success')]);
    }
}