<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: MediaController.php
 * Time: 14:46
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use think\Request;

class MediaController extends BaseController
{
    public function indexAction()
    {
        echo 1;
    }

    public function newAction(Request $request)
    {
        $accept = '{}';
        if ($request->has('ac') && !empty(trim($request->get('ac')))){
            $accept = trim($request->get('ac'));
        }
        $fileNumLimit = 10;
        if ($request->has('f_num_limit')){
            $fileNumLimit = intval($request->get('f_num_limit'));
        }
        $singleSizeLimit = 2*1024*1024;
        $allFileSizeLimit = $singleSizeLimit*intval($fileNumLimit);
        $callbacks = [];
        if ($request->has('cl')){
            $callbacks = explode('|', trim($request->get('cl')));
        }
        $showBottomBar = false;
        $yesAction = '';
        $noAction = '';
        if (input('?get.yes')){
            $showBottomBar = true;
            $yesAction = input('get.yes');
            $noAction = input('get.no');
        }
        $this->assign([
            'accept'=>$accept,
            'file_num_limit'=>$fileNumLimit,
            'all_size_limit'=>$allFileSizeLimit,
            'single_size_limit'=>$singleSizeLimit,
            'callbacks'=>$callbacks,
            'show_bottom_bar'=>$showBottomBar,
            'yes'=>$yesAction,
            'no'=>$noAction
        ]);
        return $this->fetch();
    }

    public function videoAction()
    {
        return $this->fetch();
    }

    public function uploadAction(Request $request)
    {
        $file = request()->file('file');
        $info = $file->move(ROOT_PATH . 'resources' . DS . 'upload');
        if($info){
            return json([
                'jsonrpc' => '2.0','success'=>true,
                'f_url'=>absolute_url('resources/upload/'.str_replace(DS,'/', $info->getSaveName()))
            ]);
        }else{
            return json(['jsonrpc' => '2.0','success'=>true]);
        }
    }
}