<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: PanelController.php
 * Time: 7:38
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CommonKit;
use app\common\toolKit\EnvironmentKit;
use app\common\toolKit\MenuKit;
use app\common\toolKit\SiteKit;
use think\Db;

class PanelController extends BaseController
{
    public function indexAction()
    {
        $menuId = intval(request()->get('m'));
        $menus = MenuKit::get($menuId);
        $this->assign([
            'menus' => $menus,
            'menu_id' => $menuId
        ]);
        return $this->fetch();
    }

    public function archiveAction()
    {
        $siteId = SiteKit::currentSiteId();
        $categories = cache('categories.tree.site.' . $siteId);
        $this->assign([
            'items' => json_encode(array_values($categories))
        ]);
        return $this->fetch();
    }

    public function renderAction()
    {
        $homePng = asset('share/img/home.png');
        $itemPng = asset('share/img/item.png');
        $baseItem = Db::name('block')->order('weight desc')->select();
        $treeResult[1]['id'] = '1';
        $treeResult[1]['parent'] = '#';
        $treeResult[1]['state'] = ['opened' => true];
        $treeResult[1]['icon'] = $homePng;
        $treeResult[1]['text'] = '内容标签';
        if (count($baseItem)>0){
            foreach ($baseItem as $datum){
                $key = intval($datum['id']) + 1;
                $treeResult[$key]['icon'] = $itemPng;
                $treeResult[$key]['id'] = (string)(intval($datum['id']) + 1);
                $treeResult[$key]['parent'] = '1';
                $treeResult[$key]['text'] = $datum['title'];
                $url = url('dash/block/edit', ['block_id' => $datum['id']]);
                $treeResult[$key]['a_attr'] = ['onclick' => 'switchRenderLayout(\'' . $url . '\')'];
            }
        }
        $this->assign([
            'items' => json_encode(array_values($treeResult))
        ]);
        return $this->fetch();
    }

    public function welcomeAction()
    {
        $databaseConfig = Db::connect()->getConfig();
        $dbVersionQuery = Db::query('SELECT VERSION()');
        $databaseConfig['version'] = $dbVersionQuery[0]['VERSION()'];
        $gdExtension = EnvironmentKit::gd() ? '支持' : '不支持';
        $maxUploadFileSize = EnvironmentKit::maxUploadFileSize();
        $softInfo = EnvironmentKit::softInfo();
        $manager = $this->getUser();
        $messages = CommonKit::request('http://coverprise.svipplus.com/api/provider/push',[],[]);
        if (!$messages){
            $messages = [];
        }
        $this->assign([
            'db_config'=>$databaseConfig,
            'gd'=>$gdExtension,
            'max_upload_filesize'=>$maxUploadFileSize,
            'soft_info'=>$softInfo,
            'manager'=>$manager,
            'messages'=>$messages
        ]);
        return $this->fetch();
    }
}