<?php
/**
 * Copyright: Shanghai NuLang Network Technology Co., Ltd.
 * Faith: Some things do not need others to understand.
 * Project: CoverCMS <Your world, your ambition>
 * License: http://www.svipplus.cn/license/
 * Author: The Rain° <rain@svipplus.cn>
 * File: ProductAttrController.php
 * Time: 8:29
 */

namespace app\dash\controller;


use app\common\controller\BaseController;
use app\common\toolKit\CommonKit;
use think\Db;

class ProductAttrController extends BaseController
{
    public function indexAction()
    {
        if (request()->isPost()) {
            $items = Db::name('product_attr')->order('weight desc')->select();
            $total = 0;
            if ($items) {
                $fieldType = [
                    'image' => '图片',
                    'image_group' => '图片组',
                    'video' => '视频',
                    'single_text' => '单行文本',
                    'multi_text' => '多行文本'
                ];
                $total = count($items);
                foreach ($items as &$item) {
                    $item['field_type'] = $fieldType[$item['field_type']];
                    $editUrl = url('edit', ['id' => $item['id']]);
                    $deleteUrl = url('delete', ['id' => $item['id']]);
                    $item['actions'] = '<a class="cv-btn primary" href="javascript:openDialog(' . '\'编辑产品属性\',' . '\'' . $editUrl . '\',' . '\'520px\',' . '\'330px\'' . ')">编辑</a>' . '&nbsp;&nbsp;' .
                        '<a class="cv-btn red" href="javascript:deleteProductAttrData(\'' . $deleteUrl . '\')">删除</a>';
                    $item['order'] = '<input style="width:35px;" type="text" name="cv[product_attr][' . $item['id'] . ']" value="' . $item['weight'] . '" />';
                }
            }
            return json(['total' => $total, 'rows' => $items]);
        }
        return $this->fetch();
    }

    public function newAction()
    {
        if (request()->isPost()) {
            $dataFromPost = request()->post('cv/a', null);
            if (is_null($dataFromPost) || !is_array($dataFromPost)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            if (CommonKit::isMissing(['field_type', 'label', 'field'], $dataFromPost, true)) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            $lastInsertedItem = Db::name('product_attr')->insertGetId($dataFromPost);
            if (!$lastInsertedItem) {
                return json(['success' => false, 'message' => lang('Failure')]);
            }
            return json(['success' => true, 'message' => lang('Success')]);
        }

        return $this->fetch();
    }

    public function deleteAction()
    {
        $id = intval(input('?get.id') ? input('get.id') : input('post.id', 0));
        if ($id === 0) {
            return json(['success' => false, 'message' => lang('Failure')]);
        }
        Db::name('product_attr')->where('id', $id)->delete();
        return json(['success' => true, 'message' => lang('Success')]);
    }

    public function deleteAllAction()
    {
        if (request()->isPost()) {
            if ($needDeleteRows = input('post.rows/a')) {
                if (is_array($needDeleteRows) && count($needDeleteRows) > 0) {
                    Db::name('product_attr')->delete($needDeleteRows);
                    return json(['success' => true, 'message' => lang('Success')]);
                }
            }
        }
    }

    public function orderAction()
    {
        $dataFromPost = request()->post('cv/a', null);
        $needOrders = $dataFromPost['product_attr'];
        foreach ($needOrders as $key => $value) {
            Db::name('product_attr')->where('id', $key)->update(['weight' => abs(intval($value))]);
        }
        return json(['success' => true, 'message' => lang('Success')]);
    }
}