<?php

namespace backend\controllers;

use Yii;
use common\models\ArticleCategory;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * ArticleController implements the CRUD actions for Article model.
 */
class ArticleCategoryController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'create','update','delete','display'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                ],
            ],
        ];
    }

    protected function findModel($id)
    {
        if (($model = ArticleCategory::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    /**
     * 分类管理
     */
    public function actionIndex()
    {
        $this->check_access('articleCategory');
        $dataProvider = new ActiveDataProvider([
            'query' => ArticleCategory::find(),
            'pagination'=>[
                'pagesize'=>10,
            ],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }
    /**
     * 添加分类
     */
    public function actionCreate()
    {
        $this->check_access('articleCategory');
        $model = new ArticleCategory();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $this->showmsg(1,'添加成功！');
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }
    /**
     * 修改分类
     */
    public function actionUpdate($id)
    {
        $this->check_access('articleCategory');
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $this->showmsg(1,'修改成功！');
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }
    /**
     * 删除分类
     */
    public function actionDelete($id)
    {
        $this->check_access('articleCategory');
        $this->findModel($id)->delete();
        $this->showmsg(1,'删除成功！');

        return $this->redirect(['index']);
    }
    /**
     * 分类 - 显示/隐藏
     */
    public function actionDisplay($id,$display)
    {
        $this->check_access('articleCategory');
        $model = $this->findModel($id);
        $model->display = $display;

        if ($model->save()) {
            $this->showmsg(1,'操作成功！');
            return $this->redirect(['index']);
        } else {
            $this->showmsg(0,'操作失败！');
            return $this->redirect(['index']);
        }
    }
}
