<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use common\models\Admin;
use yii\web\ForbiddenHttpException;

/**
 * ArticleController implements the CRUD actions for Article model.
 */
class BaseController extends Controller
{
    public function actions(){
        return [
            'ueditor'=>[
                'class' => 'common\widgets\ueditor\UeditorAction',
                'config'=>[
                    //上传图片配置
                    'imageUrlPrefix' => "", /* 图片访问路径前缀 */
                    'imagePathFormat' => Yii::$app->params['sitedir']."data/upload/editor/image/{yyyy}{mm}{dd}/{time}{rand:6}", /* 上传保存路径,可以自定义保存路径和文件名格式 */
                ]
            ]
        ];
    }
    /**
     * 提示
     */
    public function showmsg($status,$message){
        switch($status){
            case 1:
                $status_cn = 'success';break;
            case 0:
                $status_cn = 'danger';break;
            default:
                $status_cn = 'warning';break;
        }
        $session = Yii::$app->session;
        $session->setFlash($status_cn,$message);
    }
    /**
     * 检测权限
     */
    public function check_access($access){
        if(Yii::$app->user->identity->super!=1 && !Admin::check_access(Yii::$app->user->identity->role,$access)){
            throw new ForbiddenHttpException('你没有权限访问此页');
        }
    }
    
}
