<?php

namespace backend\controllers;

use Yii;
use common\models\Admin;
use common\models\AdminRole;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\widgets\ActiveForm;

class ManagerController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'create','update','delete','role','role-index','role-create','role-update','role-delete'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                ],
            ],
        ];
    }

    /**
     * Lists all Admin models.
     * @return mixed
     */
    public function actionIndex()
    {
        $this->check_access('manager');
        $dataProvider = new ActiveDataProvider([
            'query' => Admin::find(),
            'pagination'=>[
                'pagesize'=>10,
            ],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Creates a new Admin model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $this->check_access('manager');
        $model = new Admin();
        $model->scenario = 'create';
        if ($model->load(Yii::$app->getRequest()->post())) {
            $model->setPassword($model->password);
            $model->generateAuthKey();
            $model->generatePasswordResetToken();
            if ($model->save()) {
                $this->showmsg(1,'发布成功！');
                return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Admin model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $this->check_access('manager');
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            $model->password = $_POST['Admin']['password'];
            $model->setPassword($model->password);
            if($model->save()){
                $this->showmsg(1,'修改成功！');
                return $this->redirect(['index']);
            }
        } 
        return $this->render('update', [
            'model' => $model,
        ]);
    }
    public function actionSetStatus($id,$status)
    {
        $this->check_access('manager');
        $model = $this->findModel($id);
        if($model->super==1){
            $this->showmsg(0,'操作失败！该账号为系统内置，无法停用！');
            return $this->redirect(['index']);
        }else{
            $model->status = $status;
        }

        if ($model->save()) {
            $this->showmsg(1,'操作成功！');
            return $this->redirect(['index']);
        } else {
            $this->showmsg(0,'操作失败！');
            return $this->redirect(['index']);
        }
    }

    /**
     * Deletes an existing Admin model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->check_access('manager');
        $this->findModel($id)->delete();
        $this->showmsg(1,'删除成功！');

        return $this->redirect(['index']);
    }

    /**
     * Finds the Admin model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return Admin the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Admin::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    protected function findRoleModel($id)
    {
        if (($model = AdminRole::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    /**
     * 角色权限
     */
    public function actionRole()
    {
        $this->check_access('manager');
        $dataProvider = new ActiveDataProvider([
            'query' => AdminRole::find(),
            'pagination'=>[
                'pagesize'=>10,
            ],
        ]);

        return $this->render('role/index', [
            'dataProvider' => $dataProvider,
        ]);
    }
    /**
     * 添加角色
     */
    public function actionRoleCreate()
    {
        $this->check_access('manager');
        $model = new AdminRole();
        $model->access = array();
        if ($model->load(Yii::$app->getRequest()->post()) && $model->save()) {
            $this->showmsg(1,'添加成功！');
            return $this->redirect(['role']);
        }
        return $this->render('role/create', [
            'model' => $model,
        ]);
    }
    /**
     * 修改角色
     */
    public function actionRoleUpdate($id)
    {
        $this->check_access('manager');
        $model = $this->findRoleModel($id);
        $model->access = unserialize($model->access);
        if ($model->load(Yii::$app->getRequest()->post()) && $model->save()) {
            $this->showmsg(1,'修改成功！');
            return $this->redirect(['role']);
        }
        return $this->render('role/update', [
            'model' => $model,
        ]);
    }
    /**
     * 删除角色
     */
    public function actionRoleDelete($id)
    {
        $this->check_access('manager');
        $model = $this->findRoleModel($id);
        if($model->super!=1){
            $users = Admin::find()->where(['role'=>$id])->one();
            if($users){
                $this->showmsg(0,'该角色正在使用中，无法删除！请先删除该角色下的管理员信息再进行此操作！');
            }else{
                $model->delete();
                $this->showmsg(1,'删除成功！');
            }
        }else{
            $this->showmsg(0,'角色【'.$model->name.'】为系统内置，无法删除！');
        }
        return $this->redirect(['role']);
    }
}
