<?php

namespace backend\controllers;

use Yii;
use common\models\Config;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

class QiniuController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                ],
            ],
        ];
    }

    public function actionIndex(){
        $this->check_access('qiniu');
        $list = Config::find()->asArray()->indexBy('name')->all();
        if(Yii::$app->request->isPost){
            foreach (Yii::$app->request->post() as $key => $value) {
                Yii::$app->db->createCommand('UPDATE '.Yii::$app->db->tablePrefix.'config set `value`="'.$value.'" where `name`="'.$key.'"')->execute();
            }
            Config::updateCache();
            $this->showmsg(1,'保存成功！');
            return $this->redirect(Yii::$app->request->getReferrer());
        }
        return $this->render('index', [
            'list' => $list,
        ]);
    }
}
