<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 
use common\models\CustomService;
use common\components\CHelper;

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Article */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="custom-service-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal','enctype'=>'multipart/form-data'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'type')->dropdownList(['qq'=>'QQ','tel'=>'电话']) ?>
    <?= $form->field($model, 'value',['template'=>"{label}\n<div class=\"col-sm-3\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'ordid')->textInput(['maxlength' => true]) ?>
    
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '添加' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('custom-service/index').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
