<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = '在线客服';
$this->params['breadcrumbs'][] = ['label' => '在线客服'];
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation" class="active"><a>在线客服</a></li>
</ul>
<div class="alert alert-warning" role="alert">添加的QQ需要到【shang.qq.com】登录后在【商家沟通组建—设置】开启QQ的在线状态，否则将显示“未启用”
</div>
    
<div class="sys-form">
    <form method="post" action="<?php echo Yii::$app->urlManager->createUrl(['custom-service/index']);?>" class="form-horizontal" enctype='multipart/form-data'>
    <input type="hidden" name="_csrf-backend" value="<?=Yii::$app->request->getCsrfToken() ?>">
    <div class="form-group">
        <label class="col-sm-2 control-label">是否开启</label>
        <div class="col-sm-3">
            <label class="radio-inline"><input type="radio" name="custom_service_open" value="1" <?php if($list['custom_service_open']['value']=='1'){?>checked<?php }?>>开启</label>
            <label class="radio-inline"><input type="radio" name="custom_service_open" value="0" <?php if($list['custom_service_open']['value']=='0'){?>checked<?php }?>>关闭</label>
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <input type="submit" name="" value="保存" class="btn btn-primary">
        </div>
    </div>
    </form>
</div>

<?php Pjax::begin(); ?>    
<?= GridView::widget([
        'dataProvider' => $dataProvider,
        'layout' => "{items}\n{pager}" ,
        'columns' => [
            'value',
            [
                'attribute'=>'type',
                'format'=>'raw',
                'value'=> function($data){
                    switch ($data->type) {
                        case 'qq';
                            return 'QQ';
                            break;
                        default:
                            return '电话';
                            break;
                    }
                } 
            ],
            'ordid',
            [
                'header' => "操作",
                'class' => 'yii\grid\ActionColumn',
                'template'=> '{update} {delete}',
                'headerOptions' => ['width' => '140'],
                'buttons' => [
                    'update' => function ($url, $model, $key){
                          return Html::a('修改', ['custom-service/update','id'=>$model->id], ["class" => "btn btn-xs btn-info"]);
                    },
                    'delete' => function ($url, $model, $key) {
                            return Html::a("删除", ["custom-service/delete", "id" => $model->id], ["class" => "btn btn-xs btn-danger","onclick"=>"javascript:return confirm('确定删除吗？');"]);
                    }
                ]
            ],
        ],
    ]); ?>
<?php Pjax::end(); ?>
<?= Html::a('添加', ['create'], ['class' => 'btn btn-success']) ?>
