<?php
use yii\helpers\Html;
use yii\bootstrap\Modal;
use common\components\CHelper;

/* @var $this \yii\web\View */
/* @var $content string */
?>

<header class="main-header">

    <?= Html::a('<span class="logo-mini">APP</span><span class="logo-lg">' . Yii::$app->params['sitename'] . '</span>', Yii::$app->homeUrl, ['class' => 'logo']) ?>

    <nav class="navbar navbar-static-top" role="navigation">

        <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
        </a>

        <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">
                <li class="user user-menu">
                    <?php
                        echo Html::a('[网站首页]', CHelper::createFrontendUrl(['site/index']),['target'=>'_blank']);
                    ?>
                </li>
                <li class="user user-menu">
                    <?php
                        echo Html::a('[更新缓存]', '#', [
                            'id' => 'clearcache',
                            'data-toggle' => 'modal',
                            'data-target' => '#notice-modal',
                            'data-url'=>Yii::$app->urlManager->createUrl('site/clearcache'),
                        ]);
                    ?>
                </li>
                <li class="user user-menu">
                    <a>
                        <span class="hidden-xs">欢迎&nbsp;&nbsp;&nbsp;[<?php echo Yii::$app->user->identity->nickname?Yii::$app->user->identity->nickname:Yii::$app->user->identity->username;?>]</span>
                    </a>
                </li>
                <li class="user user-menu">
                    <a href="<?php echo Yii::$app->urlManager->createUrl('site/logout');?>" onclick="return confirm('确定退出吗？')">
                        <span class="hidden-xs">退出 <i class="fa fa-sign-out"></i></span>
                    </a>
                </li>

                <!-- User Account: style can be found in dropdown.less -->
                <li>
                    <a href="#" data-toggle="control-sidebar"></a>
                </li>
            </ul>
        </div>
    </nav>
</header>
<?php 
Modal::begin([
'size'=>'modal-sm',
'id' => 'notice-modal',
'header' => '<h4 class="modal-title">系统提示</h4>',
'footer' => '<a href="#" class="btn btn-primary" data-dismiss="modal">关闭</a>',
]); 
$js = <<<JS
$('#clearcache').click(function(){
    var url = $(this).data('url');
    $.get(url, {},
        function (data) {
            $('.modal-body').html(data);
        } 
    );
});
JS;
$this->registerJs($js);
Modal::end(); 
?>
