<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use common\components\CHelper;
use backend\assets\AppAsset; 
$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 
$this->title = '页面缓存';
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation" class="active"><a>页面缓存</a></li>
</ul>
<?php $form = ActiveForm::begin(); ?>
<table class="table table-bordered" style="width:600px;">
    <thead>
        <tr>
            <th>页面名称</th>
            <th>是否开启</th>
            <th>缓存时间</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach($list as $key=>$value){?>
        <input type="hidden" name="id[<?php echo $value['id'];?>]" value="<?php echo $value['id'];?>">
        <tr>
            <td><?php echo $value['name'];?></td>
            <td>
                <label class="radio-inline"><input type="radio" name="status[<?php echo $value['id'];?>]" value="1" <?php if($value['status']==1){?>checked<?php }?>/>是</label>
                <label class="radio-inline"><input type="radio" name="status[<?php echo $value['id'];?>]" value="0" <?php if($value['status']==0){?>checked<?php }?>/>否</label>
            </td>
            <td class="col-xs-3">
                <div class="input-group">
                  <input type="text" name="time[<?php echo $value['id'];?>]" class="form-control" value="<?php echo $value['time'];?>">
                  <div class="input-group-addon">秒</div>
                </div>
            </td>
        </tr>
    <?php }?>
    </tbody>
</table>
<?= Html::submitButton('保存', ['class' => 'btn btn-primary']) ?>
<?php ActiveForm::end(); ?>