<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = '产品管理';
$this->params['breadcrumbs'][] = ['label' => '产品管理', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation" class="active"><a>产品列表</a></li>
  <li role="presentation"><a href="<?= Yii::$app->urlManager->createUrl('/product-category');?>">产品分类</a></li>
</ul>
<?php Pjax::begin(); ?>    
<?= GridView::widget([
        'dataProvider' => $dataProvider,
        'layout' => "{items}\n{pager}" ,
        'columns' => [
            'name',
            'cname',
            [
                'attribute'=>'display',
                'format'=>'raw',
                'value'=> function($data){
                    switch ($data->display) {
                        case '1';
                            return '<font color="green"><b>显示</b></font>';
                            break;
                        default:
                            return '<font color="red"><b>隐藏</b></font>';
                            break;
                    }
                } 
            ],
            [
                'attribute'=>'updatetime',
                'format' => ['date', 'php:Y-m-d H:i'],
            ],
            [
                'header' => "操作",
                'class' => 'yii\grid\ActionColumn',
                'template'=> '{view} {update} {delete}',
                'headerOptions' => ['width' => '140'],
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        if($model->display==1){
                            $tag_a = Html::a('隐藏',['product/display', 'id'=>$model->id,'display'=>0], ['class' => "btn btn-xs btn-warning", 'title' => '隐藏']);
                        }else{
                            $tag_a = Html::a('显示',['product/display', 'id'=>$model->id,'display'=>1], ['class' => "btn btn-xs btn-success", 'title' => '显示']);
                        }
                        return $tag_a;
                    },
                    'update' => function ($url, $model, $key){
                          return Html::a('修改', ['product/update','id'=>$model->id], ["class" => "btn btn-xs btn-info"]);
                    },
                    'delete' => function ($url, $model, $key) {
                            return Html::a("删除", ["product/delete", "id" => $model->id], ["class" => "btn btn-xs btn-danger","onclick"=>"javascript:return confirm('确定删除吗？');"]);
                    }
                ]
            ],
        ],
    ]); ?>
<?php Pjax::end(); ?>
<?= Html::a('添加产品', ['create'], ['class' => 'btn btn-success']) ?>
