<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Article */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="article-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'controller')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'action')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'rule',['template'=>"{label}\n<div class=\"col-sm-4\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'status')->dropdownList(['1'=>'启用','0'=>'停用']) ?>
    
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '添加' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('route/index').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
