<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use common\components\CHelper;
use backend\assets\AppAsset; 
$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 
$this->title = '路由设置';
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation"><a href="<?php echo Yii::$app->urlManager->createUrl('route/index');?>">路由设置</a></li>
  <li role="presentation" class="active"><a>路由规则</a></li>
</ul>
<?= GridView::widget([
    'dataProvider' => $dataProvider,
    'layout' => "{items}{pager}" ,
    'columns' => [
        'name',
        'controller',
        'action',
        'rule',
        [
            'attribute'=>'status',
            'format'=>'raw',
            'value'=> function($data){
                switch ($data->status) {
                    case '1';
                        return '<font color="green"><b>可用</b></font>';
                        break;
                    default:
                        return '<font color="red"><b>不可用</b></font>';
                        break;
                }
            } 
        ],
        [
            'header' => "操作",
            'class' => 'yii\grid\ActionColumn',
            'template'=> '{view} {update} {delete}',
            'headerOptions' => ['width' => '140'],
            'buttons' => [
                'view' => function ($url, $model, $key) {
                    if($model->status==1){
                        $tag_a = Html::a('停用',['route/set-status', 'id'=>$model->id,'status'=>0], ['class' => "btn btn-xs btn-warning", 'title' => '停用']);
                    }else{
                        $tag_a = Html::a('启用',['route/set-status', 'id'=>$model->id,'status'=>1], ['class' => "btn btn-xs btn-success", 'title' => '启用']);
                    }
                    return $tag_a;
                },
                'update' => function ($url, $model, $key){
                      return Html::a('修改', ['route/update','id'=>$model->id], ["class" => "btn btn-xs btn-info"]);
                },
                'delete' => function ($url, $model, $key) {
                        return Html::a("删除", ["route/delete", "id" => $model->id], ["class" => "btn btn-xs btn-danger","onclick"=>"javascript:return confirm('确定删除吗？');"]);
                }
            ]
        ],
    ],
]); ?>
<?= Html::a('添加规则', ['create'], ['class' => 'btn btn-success']) ?>
