<?php
namespace common\components;
use yii;
class CHelper
{
    public static function getUploadFileName($fileName, $column = 'pic')
    {
        return rand(1,10000).time().strrchr($_FILES[$fileName]["name"][$column],'.');
    }
    public static function byteFormat($size,$dec=1){
        $a = array("B", "KB", "MB", "GB", "TB", "PB");
        $pos = 0;
        while ($size >= 1024) {
             $size /= 1024;
               $pos++;
        }
        return round($size,$dec)." <span>".$a[$pos]."</span>";
    }
    //创建目录
    public static function mkdirs($dir)  
    {  
        if(!is_dir($dir))  
        {  
            if(!self::mkdirs(dirname($dir))){  
                return false;  
            }  
            if(!mkdir($dir,0777)){  
                return false;  
            }  
        }  
        return true;  
    }
    /**
     * 删除目录
     */
    public static function rmdirs($dir,$rm_self=false)  
    {  
        $d = dir($dir);  
        while (false !== ($child = $d->read())){  
            if($child != '.' && $child != '..'){  
                if(is_dir($dir.'/'.$child)){
                    self::rmdirs($dir.'/'.$child,true);  
                } 
                else{
                    unlink($dir.'/'.$child);  
                } 
            }  
        }  
        $d->close();
        $rm_self && rmdir($dir);  
    }
    /**
     * 生成资源展示url
     */
    public static function attach($file,$path=''){
        if(empty($file)) return false;
        if (false===strpos($file,"http://")) {
            return Yii::$app->params['sitedir'].'data/upload/'.$path.'/'.$file;
        }else{
            return $file;
        }
    } 
    public static function cutStr($string, $length, $etc = '...'){
        $result = '';
        $string = html_entity_decode(trim(strip_tags($string)), ENT_QUOTES, 'UTF-8');
        $strlen = strlen($string);
        for ($i = 0; (($i < $strlen) && ($length > 0)); $i++)
        {
        if ($number = strpos(str_pad(decbin(ord(substr($string, $i, 1))), 8, '0', STR_PAD_LEFT), '0'))
            {
            if ($length < 1.0)
                {
            break;
            }
            $result .= substr($string, $i, $number);
            $length -= 1.0;
            $i += $number - 1;
        }
            else
            {
            $result .= substr($string, $i, 1);
            $length -= 0.5;
        }
        }
        $result = htmlspecialchars($result, ENT_QUOTES, 'UTF-8');
        if ($i < $strlen)
        {
        $result .= $etc;
        }
        return $result;
    }
    // 分词
    public static function getTags($title, $num=10,$mode = false)
    {
        // vendor('pscws4.pscws4#class');
        $pscws = new PSCWS4();
        $pscws->set_dict(ROOT_PATH . 'data/scws/dict.utf8.xdb');
        $pscws->set_rule(ROOT_PATH . 'data/scws/rules.utf8.ini');
        $pscws->set_ignore(true);
        $pscws->send_text($title);
        if($mode){
            //开启二元分词
            $pscws->set_multi(2);
            while (false !== $tag = $pscws->get_result()) {
                foreach ($tag as $key => $val) {
                    $tags[] = $val['word'];
                }
            }
        }else{
            //不开启二元分词，返回系统计算出来的最关键词汇列表
            $words = $pscws->get_tops($num);
            $tags = array();
            foreach ($words as $val) {
                $tags[] = $val['word'];
            }
        }
        $pscws->close();
        return $tags;
    }
    /**
     * 用于后台生成前台链接
     */
    public static function createFrontendUrl($params,$absolute=false){
        if(Yii::$app->params['enablePrettyUrl']=='true'){
            $url_function = $absolute?'createAbsoluteUrl':'createUrl';
            return Yii::$app->urlManagerFrontend->$url_function($params);
        }else{
            $r = '';
            foreach ($params as $key => $value) {
                if($key==0){
                    $r .= $value;
                }else{
                    $r .= '&'.$key.'='.$value;
                }
            }
            if($absolute){
                return Yii::$app->params['sitedomain'].Yii::$app->params['sitedir'].'index.php?r='.$r;
            }else{
                return Yii::$app->params['sitedir'].'index.php?r='.$r;
            }
        }
    }
}
