<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "{{%ad_category}}".
 *
 * @property integer $id
 * @property string $alias
 * @property string $type
 * @property string $name
 * @property integer $width
 * @property integer $height
 * @property integer $max
 */
class AdCategory extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%ad_category}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['alias', 'type', 'name', 'width', 'height', 'max'], 'required'],
            [['type', 'width', 'height', 'max'], 'integer'],
            [['alias', 'name'], 'string', 'max' => 100],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'alias' => '调用名称',
            'type' => '类型',
            'name' => '名称',
            'width' => '宽度',
            'height' => '高度',
            'max' => '广告数量',
        ];
    }
    public static function getCache($id=0){
        $cache = Yii::$app->cache;
        $data = $cache->get('ad_category');
        if ($data === false) {
            $data = self::find()->select(['name','id'])->asArray()->indexBy('id')->column();
            $cache->set('ad_category', $data);
        }
        if($id>0){
            return $data[$id];
        }
        return $data;
    }
    public function afterSave($insert, $changedAttributes){
        parent::afterSave($insert, $changedAttributes);
        $cache = Yii::$app->cache;
        $cache->delete('ad_category');
        return true;
    }
    public function afterDelete(){
        parent::afterDelete();
        $cache = Yii::$app->cache;
        $cache->delete('ad_category');
        return true;
    }
}
