<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "{{%custom_service}}".
 *
 * @property string $id
 * @property string $value
 * @property string $type
 * @property string $ordid
 */
class CustomService extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%custom_service}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['value', 'type', 'ordid'], 'required'],
            [['ordid'], 'integer'],
            [['value', 'type'], 'string', 'max' => 30],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'value' => '号码',
            'type' => '类型',
            'ordid' => '排序',
        ];
    }
    public static function getCache($type='qq'){
        $cache = Yii::$app->cache;
        $data = $cache->get('custom_service_'.$type);
        if ($data === false) {
            $data = self::find()->where(['type'=>$type])->asArray()->orderBy(['ordid'=>'desc'])->all();
            $cache->set('custom_service_'.$type, $data);
        }
        return $data;
    }
    public function afterSave($insert, $changedAttributes){
        parent::afterSave($insert, $changedAttributes);
        $cache = Yii::$app->cache;
        $cache->delete('custom_service_qq');
        $cache->delete('custom_service_tel');
        return true;
    }
    public function afterDelete(){
        parent::afterDelete();
        $cache = Yii::$app->cache;
        $cache->delete('custom_service_qq');
        $cache->delete('custom_service_tel');
        return true;
    }
}
