<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "{{%job}}".
 *
 * @property string $id
 * @property string $uid
 * @property string $author
 * @property string $name
 * @property string $district
 * @property string $wage
 * @property string $amount
 * @property string $days
 * @property string $content
 * @property string $addtime
 * @property integer $display
 */
class Job extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%job}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'district', 'content', 'display'], 'required'],
            [['uid', 'amount', 'days', 'addtime', 'display'], 'integer'],
            [['content'], 'string'],
            [['author', 'name', 'district', 'wage'], 'string', 'max' => 30],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uid' => 'Uid',
            'author' => 'Author',
            'name' => '职位名称',
            'district' => '工作地点',
            'wage' => '薪资待遇',
            'amount' => '招聘人数',
            'days' => '有效期',
            'content' => '招聘详情',
            'addtime' => '发布时间',
            'display' => '显示/隐藏',
        ];
    }
    public function beforeSave($insert)
    {
        $timestamp = time();
        if (parent::beforeSave($insert)) {
            !$this->amount && $this->amount = 0;
            !$this->days && $this->days = 0;
            if($insert) {
                $this->uid = Yii::$app->user->id;
                $this->author = Yii::$app->user->identity->username;
                $this->addtime = $timestamp;
            }
            return true;
        } else {
            return false;
        }
    }
}
