<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "{{%pagecache}}".
 *
 * @property string $id
 * @property string $name
 * @property string $alias
 * @property integer $status
 * @property string $time
 */
class Pagecache extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%pagecache}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'alias', 'status', 'time'], 'required'],
            [['status', 'time'], 'integer'],
            [['name', 'alias'], 'string', 'max' => 30],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'alias' => 'Alias',
            'status' => 'Status',
            'time' => 'Time',
        ];
    }
    public static function getCache(){
        $cache = Yii::$app->cache;
        $data = $cache->get('pagecache');
        if ($data === false) {
            $data = self::find()->select(['status','time','alias'])->asArray()->indexBy('alias')->all();
            $cache->set('pagecache', $data);
        }
        return $data;
    }
    public static function updateCache(){
        Yii::$app->cache->delete('pagecache');
        return true;
    }
}
