<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use common\models\Article;
use common\models\Product;

class AjaxController extends Controller
{

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }
    public function actionNewsClick($id){
        if (($model = Article::findOne($id)) == null) {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
        $model->click += 1;
        $model->save();
        $this->ajaxReturn(1,'请求成功！',$model->click);
    }
    public function actionProductClick($id){
        if (($model = Product::findOne($id)) == null) {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
        $model->click += 1;
        $model->save();
        $this->ajaxReturn(1,'请求成功！',$model->click);
    }
    /**
     * ---------------------------------------
     * ajax标准返回格式
     * @param $status integer  错误码
     * @param $message string  提示信息
     * @param $data mixed  返回数据
     * @return void
     * ---------------------------------------
     */
    public function ajaxReturn($status = 0, $message = 'success', $data = ''){
        /* api标准返回格式 */
        $json = array(
            'status' => $status,
            'message'  => $message,
            'data'  => $data,
        );
        header('Content-Type:application/json; charset=utf-8');
        exit(json_encode($json));
    }
}
