<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use frontend\assets\AppAsset;
use frontend\components\CLinkPager;

AppAsset::register($this);
$this->registerCssFile($this->theme->getUrl('css/job.css'));
$this->seo_title = $category;
$this->seo_keywords = $category;
$this->seo_description = $category;
?>
<div class="row">
  <div class="col-md-12">
    <div class="container-fluid job-list">
    <?php foreach($list as $key=>$value){?>
      <div class="row job-item">
          <div class="row title"><h3><?php echo Html::encode($value['name']);?></h3></div>
          <div class="row info">
              <span>发布时间：<?php echo date('Y-m-d',$value['addtime']);?></span>
              <span>招聘人数：<?php echo $value['amount']?Html::encode($value['amount']):'若干';?></span>
              <span>工作地点：<?php echo $value['district']?Html::encode($value['district']):'不限';?></span>
              <span>薪资待遇：<?php echo $value['wage']?Html::encode($value['wage']):'面议';?></span>
           </div>
           <div class="row content">
             <?php echo $value['content'];?>
           </div>
      </div>
      <?php }?>
    </div>
  </div>
</div>