<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use common\models\About;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
  <?= Html::csrfMetaTags() ?>
  <title><?= ($this->seo_title?(Html::encode($this->seo_title).' - '):'').Yii::$app->params['sitename'] ?></title>
  <?= $this->seo_keywords?$this->registerMetaTag(['name'=>'keywords','content'=>Html::encode($this->seo_keywords.','.Yii::$app->params['sitename'])]):''; ?>
  <?= $this->seo_description?$this->registerMetaTag(['name'=>'description','content'=>Html::encode($this->seo_description.','.Yii::$app->params['sitename'])]):''; ?>
    <?php $this->head() ?>
  <?= $this->registerMetaTag(['name'=>'author','content'=>Yii::$app->params['author']]); ?>
  <?= $this->registerMetaTag(['name'=>'copyright','content'=>Yii::$app->params['copyright']]); ?>
  <link rel="shortcut icon" href="<?php echo Yii::$app->params['sitedir'];?>favicon.ico" />
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">
    <?php
    NavBar::begin([
        'brandLabel' => Yii::$app->params['sitename'],
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
    $about_list = About::getCache();
    $menuItems = [
        [
          'label' => '首页', 
          'url' => ['/site/index']
        ],
        [
          'label' => '关于我们', 
          'url' => ['/about/detail','id'=>$about_list[0]['id']]
        ],
        ['label' => '产品中心', 'url' => ['/product/index']],
        ['label' => '新闻中心', 'url' => ['/news/index']],
        ['label' => '招贤纳士', 'url' => ['/job/index']],
    ];
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => $menuItems,
    ]);
    NavBar::end();
    $banner = strtolower(Yii::$app->controller->id).'.png';
    $banner_url = $this->theme->getUrl('images/banner/'.$banner);
    ?>
    <header class="main-header" style="background-image: url(<?= $banner_url;?>);background-repeat:no-repeat;">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 web-desc">
                </div>
            </div>
        </div>
    </header>
    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left"><strong>Copyright &copy; <?= date('Y') ?> <a href="http://yunduocms.com" target="_blank">yunduocms.com</a></strong> All Right Reserved <?= Yii::$app->params['icp']; ?></p>

        <p class="pull-right">Powered by <a href="http://yunduocms.com" target="_blank">云朵CMS v1.0</a> <?= Yii::$app->params['statistics']; ?></p>
    </div>
</footer>

<?php $this->endBody() ?>
<?= $this->registerCssFile($this->theme->getUrl('css/site.css'));?>
<?php 
    if(Yii::$app->params['custom_service_open']==1){
        echo frontend\widgets\LeftseadWidget::widget();
    }
?>
</body>
</html>
<?php $this->endPage() ?>
