<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use frontend\assets\AppAsset;

AppAsset::register($this);
$this->registerCssFile($this->theme->getUrl('css/product.css'));
$this->seo_title = $model->seo_title;
$this->seo_keywords = $model->seo_keywords;
$this->seo_description = $model->seo_description;
?>
<div class="row">
  <div class="col-md-3">
    <?= frontend\widgets\ProductCategoryWidget::widget();?>
  </div>
  <div class="col-md-9">
    <div class="container-fluid product-detail">
      <div class="row product-title">
        <h1><?php echo Html::encode($model->name);?></h1>
      </div>
      <div class="row product-info">
        <span>所属分类：<?php echo Html::encode($model->cname);?></span>
        <span>更新时间：<?php echo date('Y-m-d',$model->updatetime);?></span>
        <span>作者：<?php echo Html::encode($model->author);?></span>
        <span>浏览量：<span id="click_num">0</span></span>
      </div>
      <div class="row product-content">
        <?php echo $model->content;?>
      </div>
    </div>
  </div>
</div>
  <?php
    $this->registerJs('
      $.getJSON("'.Yii::$app->urlManager->createUrl(['ajax/product-click','id'=>$model->id]).'",function(result){
        if(result.status==1){
          $("#click_num").html(result.data);
        }
      });
    ');
  ?>