<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use frontend\assets\AppAsset;
use frontend\components\CLinkPager;

AppAsset::register($this);
$this->registerCssFile($this->theme->getUrl('css/product.css'));
$this->seo_title = $category;
$this->seo_keywords = $category;
$this->seo_description = $category;
?>
<div class="row">
  <div class="col-md-3">
    <?= frontend\widgets\ProductCategoryWidget::widget();?>
  </div>
  <div class="col-md-9">
    <div class="container-fluid product-list">
    <?php foreach($list as $key=>$value){?>
        <div class="col-xs-3 product-item">
            <div class="row thumb"><a href="<?php echo $value['url'];?>" target="<?php echo $value['target'];?>" class="product-thumb">
              <img src="<?php echo $value['thumb'];?>" alt="<?php echo Html::encode($value['name']);?>">
            </a></div>
            <div class="row title"><h4><a href="<?php echo $value['url'];?>" target="<?php echo $value['target'];?>" title="<?php echo Html::encode($value['name']);?>"><?php echo Html::encode($value['name']);?></a></h4></div>
            <div class="row price">￥<?php echo $value['price'];?></div>
        </div>
      <?php }?>
    </div>
    <?= CLinkPager::widget(['pagination' => $pages]); ?>
  </div>
</div>